/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ChangeVetoException;
import org.eclipse.core.databinding.observable.value.IValueChangingListener;
import org.eclipse.core.databinding.observable.value.IVetoableValue;
import org.eclipse.core.databinding.observable.value.ValueChangingEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.internal.databinding.observable.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVetoableValue<T>
extends AbstractObservableValue<T>
implements IVetoableValue<T> {
    protected ListenerList<IValueChangingListener<T>> valueChangingListenerList = null;

    public AbstractVetoableValue() {
        this(Realm.getDefault());
    }

    public AbstractVetoableValue(Realm realm) {
        super(realm);
    }

    @Override
    protected final void doSetValue(T value) {
        Object currentValue = this.doGetValue();
        ValueDiff diff = Diffs.createValueDiff(currentValue, value);
        boolean okToProceed = this.fireValueChanging(diff);
        if (!okToProceed) {
            throw new ChangeVetoException("Change not permitted");
        }
        this.doSetApprovedValue(value);
        if (!Util.equals(diff.getOldValue(), diff.getNewValue())) {
            this.fireValueChange(diff);
        }
    }

    protected abstract void doSetApprovedValue(T var1);

    @Override
    public synchronized void addValueChangingListener(IValueChangingListener<T> listener) {
        if (this.valueChangingListenerList == null) {
            this.valueChangingListenerList = new ListenerList();
        }
        this.addListener(this.valueChangingListenerList, listener);
    }

    @Override
    public synchronized void removeValueChangingListener(IValueChangingListener<T> listener) {
        if (this.valueChangingListenerList != null) {
            this.removeListener(this.valueChangingListenerList, listener);
        }
    }

    @Override
    protected boolean hasListeners() {
        return this.valueChangingListenerList != null && this.valueChangingListenerList.hasListeners() || super.hasListeners();
    }

    protected boolean fireValueChanging(ValueDiff<T> diff) {
        this.checkRealm();
        ValueChangingEvent<T> event = new ValueChangingEvent<T>(this, diff);
        if (this.valueChangingListenerList != null) {
            this.valueChangingListenerList.fireEvent(event);
        }
        return !event.veto;
    }
}

