/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComputedSet<E>
extends AbstractObservableSet<E> {
    private Set<E> cachedSet = new HashSet();
    private boolean dirty = true;
    private boolean stale = false;
    private IObservable[] dependencies = new IObservable[0];
    private IChangeListener privateChangeInterface = new PrivateChangeInterface();
    private IStaleListener privateStaleInterface = new PrivateStaleInterface();
    private Runnable privateRunnableInterface = new PrivateRunnableInterface();
    private Object elementType;

    public ComputedSet() {
        this(Realm.getDefault(), null);
    }

    public ComputedSet(Object elementType) {
        this(Realm.getDefault(), elementType);
    }

    public ComputedSet(Realm realm) {
        this(realm, null);
    }

    public ComputedSet(Realm realm, Object elementType) {
        super(realm);
        this.elementType = elementType;
    }

    protected int doGetSize() {
        return this.doGetSet().size();
    }

    private final Set<E> getSet() {
        this.getterCalled();
        return this.doGetSet();
    }

    @Override
    protected Set<E> getWrappedSet() {
        return this.doGetSet();
    }

    final Set<E> doGetSet() {
        if (this.dirty) {
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.privateRunnableInterface, this.privateChangeInterface, null);
            this.stale = false;
            int i = 0;
            while (i < newDependencies.length) {
                if (newDependencies[i].isStale()) {
                    this.makeStale();
                    break;
                }
                ++i;
            }
            if (!this.stale) {
                i = 0;
                while (i < newDependencies.length) {
                    newDependencies[i].addStaleListener(this.privateStaleInterface);
                    ++i;
                }
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedSet;
    }

    protected abstract Set<E> calculate();

    private void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.makeStale();
            this.stopListening();
            final HashSet<E> oldSet = new HashSet<E>(this.cachedSet);
            this.fireSetChange(new SetDiff<E>(){
                SetDiff<E> delegate;

                private SetDiff<E> getDelegate() {
                    if (this.delegate == null) {
                        this.delegate = Diffs.computeSetDiff(oldSet, ComputedSet.this.getSet());
                    }
                    return this.delegate;
                }

                @Override
                public Set<E> getAdditions() {
                    return this.getDelegate().getAdditions();
                }

                @Override
                public Set<E> getRemovals() {
                    return this.getDelegate().getRemovals();
                }
            });
        }
    }

    private void stopListening() {
        if (this.dependencies != null) {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this.privateChangeInterface);
                observable.removeStaleListener(this.privateStaleInterface);
                ++i;
            }
            this.dependencies = null;
        }
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    @Override
    public boolean isStale() {
        this.getSet();
        return this.stale;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeSetForListeners();
    }

    @Override
    public synchronized void addSetChangeListener(ISetChangeListener<E> listener) {
        super.addSetChangeListener(listener);
        this.computeSetForListeners();
    }

    private void computeSetForListeners() {
        this.getRealm().exec(new Runnable(){

            public void run() {
                if (ComputedSet.this.dependencies == null) {
                    ComputedSet.this.getSet();
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.stopListening();
        super.dispose();
    }

    private class PrivateChangeInterface
    implements IChangeListener {
        private PrivateChangeInterface() {
        }

        public void handleChange(ChangeEvent event) {
            ComputedSet.this.makeDirty();
        }
    }

    private class PrivateRunnableInterface
    implements Runnable {
        private PrivateRunnableInterface() {
        }

        public void run() {
            ComputedSet.this.cachedSet = ComputedSet.this.calculate();
            if (ComputedSet.this.cachedSet == null) {
                ComputedSet.this.cachedSet = Collections.emptySet();
            }
        }
    }

    private class PrivateStaleInterface
    implements IStaleListener {
        private PrivateStaleInterface() {
        }

        public void handleStale(StaleEvent event) {
            if (!ComputedSet.this.dirty) {
                ComputedSet.this.makeStale();
            }
        }
    }
}

