/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.DecoratingObservableMap;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.internal.databinding.observable.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiObservableMap<K, V>
extends DecoratingObservableMap<K, V> {
    private Map<V, K> valuesToSingleKeys = null;
    private Map<V, Set<K>> valuesToSetsOfKeys = null;

    public BidiObservableMap(IObservableMap<K, V> wrappedMap) {
        super(wrappedMap, false);
    }

    @Override
    protected void firstListenerAdded() {
        this.valuesToSingleKeys = new HashMap<V, K>();
        this.valuesToSetsOfKeys = new HashMap<V, Set<K>>();
        for (Map.Entry entry : this.entrySet()) {
            this.addMapping(entry.getKey(), entry.getValue());
        }
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        this.valuesToSingleKeys.clear();
        this.valuesToSetsOfKeys.clear();
        this.valuesToSingleKeys = null;
        this.valuesToSetsOfKeys = null;
    }

    @Override
    protected void handleMapChange(MapChangeEvent<K, V> event) {
        MapDiff diff = event.diff;
        for (Object addedKey : diff.getAddedKeys()) {
            this.addMapping(addedKey, diff.getNewValue(addedKey));
        }
        for (Object changedKey : diff.getChangedKeys()) {
            this.removeMapping(changedKey, diff.getOldValue(changedKey));
            this.addMapping(changedKey, diff.getNewValue(changedKey));
        }
        for (Object removedKey : diff.getRemovedKeys()) {
            this.removeMapping(removedKey, diff.getOldValue(removedKey));
        }
        super.handleMapChange(event);
    }

    @Override
    public boolean containsValue(Object value) {
        this.getterCalled();
        if (this.valuesToSingleKeys != null) {
            return this.valuesToSingleKeys.containsKey(value) || this.valuesToSetsOfKeys.containsKey(value);
        }
        return super.containsValue(value);
    }

    private void addMapping(K key, V value) {
        if (this.valuesToSingleKeys.containsKey(value)) {
            K element = this.valuesToSingleKeys.get(value);
            HashSet<K> set = new HashSet<K>(Collections.singleton(element));
            this.valuesToSingleKeys.remove(value);
            this.valuesToSetsOfKeys.put((HashSet<K>)value, (Set<V>)set);
            set.add(key);
        } else if (this.valuesToSetsOfKeys.containsKey(value)) {
            Set<K> keySet = this.valuesToSetsOfKeys.get(value);
            keySet.add(key);
        } else {
            this.valuesToSingleKeys.put(value, key);
        }
    }

    private void removeMapping(Object key, V value) {
        if (this.valuesToSingleKeys.containsKey(value)) {
            K element = this.valuesToSingleKeys.get(value);
            if (element == key || element != null && element.equals(key)) {
                this.valuesToSingleKeys.remove(value);
            }
        } else if (this.valuesToSetsOfKeys.containsKey(value)) {
            Set<K> keySet = this.valuesToSetsOfKeys.get(value);
            keySet.remove(key);
            if (keySet.isEmpty()) {
                this.valuesToSetsOfKeys.remove(value);
            }
        }
    }

    public Set<K> getKeys(Object value) {
        if (this.valuesToSingleKeys == null) {
            return this.findKeys(value);
        }
        if (this.valuesToSingleKeys.containsKey(value)) {
            return Collections.singleton(this.valuesToSingleKeys.get(value));
        }
        if (this.valuesToSetsOfKeys.containsKey(value)) {
            return Collections.unmodifiableSet(this.valuesToSetsOfKeys.get(value));
        }
        return Collections.emptySet();
    }

    private Set<K> findKeys(Object value) {
        HashSet keys = new HashSet();
        for (Map.Entry entry : this.entrySet()) {
            if (!Util.equals(entry.getValue(), value)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public synchronized void dispose() {
        if (this.valuesToSingleKeys != null) {
            this.valuesToSingleKeys.clear();
            this.valuesToSingleKeys = null;
        }
        if (this.valuesToSetsOfKeys != null) {
            this.valuesToSetsOfKeys.clear();
            this.valuesToSetsOfKeys = null;
        }
        super.dispose();
    }
}

