/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.swt;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.internal.databinding.provisional.swt.ControlCreator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdatingComposite
extends Composite {
    public final String key = "org.eclipse.databinding.controlcreator";
    private boolean dirty = true;
    private IObservable[] dependencies = null;
    List<Control> remainder = null;
    private IChangeListener privateChangeInterface = new PrivateChangeInterface();
    private Runnable privateRunnableInterface = new PrivateRunnableInterface();
    private ControlSetObservable computeSizeObservable = new ControlSetObservable(Realm.getDefault());

    public UpdatingComposite(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UpdatingComposite.this.stopListening();
            }
        });
    }

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.stopListening();
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (UpdatingComposite.this.isDisposed()) {
                        return;
                    }
                    UpdatingComposite.this.createAndTrackControls();
                    UpdatingComposite.this.layout(false);
                    UpdatingComposite.this.computeSizeObservable.fireChange();
                }
            });
        }
    }

    protected void createAndTrackControls() {
        IObservable[] newDependencies = ObservableTracker.runAndMonitor((Runnable)this.privateRunnableInterface, (IChangeListener)this.privateChangeInterface, null);
        this.dependencies = newDependencies;
        this.dirty = false;
    }

    private void remove(Control control) {
        ControlCreator creator = (ControlCreator)control.getData("org.eclipse.databinding.controlcreator");
        creator.remove(control);
        control.dispose();
    }

    private void stopListening() {
        if (this.dependencies != null) {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this.privateChangeInterface);
                ++i;
            }
            this.dependencies = null;
        }
    }

    <T extends Control> T create(ControlCreator<T> controlCreator) {
        ObservableTracker.setIgnore((boolean)true);
        try {
            T matchingControl = null;
            for (Control control : this.remainder) {
                if (!controlCreator.equals(control.getData("org.eclipse.databinding.controlcreator"))) continue;
                matchingControl = controlCreator.typeControl(control);
                break;
            }
            if (matchingControl != null) {
                if (matchingControl != this.remainder.get(0)) {
                    matchingControl.moveAbove(this.remainder.get(0));
                }
                this.remainder.remove(matchingControl);
            } else {
                matchingControl = controlCreator.createControl();
                matchingControl.setData("org.eclipse.databinding.controlcreator", controlCreator);
                controlCreator.controls.add(matchingControl);
                if (!this.remainder.isEmpty()) {
                    matchingControl.moveAbove(this.remainder.get(0));
                }
            }
            T t = matchingControl;
            return t;
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    protected abstract void createControls();

    public Point computeSize(int wHint, int hHint, boolean changed) {
        ObservableTracker.getterCalled((IObservable)this.computeSizeObservable);
        return super.computeSize(wHint, hHint, changed);
    }

    private class ControlSetObservable
    extends AbstractObservable {
        private ControlSetObservable(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return false;
        }

        public void fireChange() {
            super.fireChange();
        }
    }

    private class PrivateChangeInterface
    implements IChangeListener {
        private PrivateChangeInterface() {
        }

        public void handleChange(ChangeEvent event) {
            UpdatingComposite.this.makeDirty();
        }
    }

    private class PrivateRunnableInterface
    implements Runnable {
        private PrivateRunnableInterface() {
        }

        public void run() {
            UpdatingComposite.this.remainder = new LinkedList<Control>();
            UpdatingComposite.this.remainder.addAll(Arrays.asList(UpdatingComposite.this.getChildren()));
            UpdatingComposite.this.createControls();
            for (Control control : UpdatingComposite.this.remainder) {
                UpdatingComposite.this.remove(control);
            }
        }
    }
}

