/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionTreeContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableSetTreeContentProvider<E>
implements ITreeContentProvider {
    private final ObservableCollectionTreeContentProvider<E> impl;

    public ObservableSetTreeContentProvider(IObservableFactory<?, IObservableSet<E>> setFactory, TreeStructureAdvisor structureAdvisor) {
        this.impl = new Impl(setFactory, structureAdvisor);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.impl.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        return this.impl.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.impl.getParent(element);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet<E> getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet<E> getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Impl
    extends ObservableCollectionTreeContentProvider<E> {
        Impl(IObservableFactory<?, IObservableSet<E>> setFactory, TreeStructureAdvisor structureAdvisor) {
            super(setFactory, structureAdvisor);
        }

        @Override
        protected IObservablesListener createCollectionChangeListener(Object parentElement) {
            return new SetChangeListener(parentElement);
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection<E> collection, IObservablesListener listener) {
            IObservableSet set = (IObservableSet)collection;
            ISetChangeListener setListener = (ISetChangeListener)listener;
            set.addSetChangeListener(setListener);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection<E> collection, IObservablesListener listener) {
            IObservableSet set = (IObservableSet)collection;
            ISetChangeListener setListener = (ISetChangeListener)listener;
            set.removeSetChangeListener(setListener);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SetChangeListener
        implements ISetChangeListener<E> {
            final Object parentElement;

            public SetChangeListener(Object parentElement) {
                this.parentElement = parentElement;
            }

            public void handleSetChange(SetChangeEvent<E> event) {
                if (Impl.this.isViewerDisposed()) {
                    return;
                }
                Set localAdditions = event.diff.getAdditions();
                Set localRemovals = event.diff.getRemovals();
                Set knownElementAdditions = ViewerElementSet.withComparer(Impl.this.comparer);
                knownElementAdditions.addAll(localAdditions);
                knownElementAdditions.removeAll((Collection<?>)Impl.this.knownElements);
                Set knownElementRemovals = Impl.this.findPendingRemovals(this.parentElement, localRemovals);
                knownElementRemovals.retainAll((Collection<?>)Impl.this.knownElements);
                Impl.this.knownElements.addAll(knownElementAdditions);
                if (Impl.this.realizedElements != null) {
                    Impl.this.realizedElements.removeAll((Collection)knownElementRemovals);
                }
                for (Object child : localAdditions) {
                    Impl.this.getOrCreateNode(child).addParent(this.parentElement);
                }
                Impl.this.viewerUpdater.add(this.parentElement, localAdditions.toArray());
                Impl.this.viewerUpdater.remove(this.parentElement, localRemovals.toArray());
                for (Object child : localRemovals) {
                    ObservableCollectionTreeContentProvider.TreeNode childNode = Impl.this.getExistingNode(child);
                    if (childNode == null) continue;
                    childNode.removeParent(this.parentElement);
                }
                if (Impl.this.realizedElements != null) {
                    Impl.this.realizedElements.addAll(knownElementAdditions);
                }
                Impl.this.knownElements.removeAll((Collection)knownElementRemovals);
            }
        }
    }
}

