/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.databinding.preference.AggregateObservableValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceObservables {
    private List<IEclipsePreferences> nodes = new ArrayList<IEclipsePreferences>();

    public static PreferenceObservables observe(List<IScopeContext> scopes, String qualifier) {
        return new PreferenceObservables(scopes, qualifier);
    }

    public static PreferenceObservables observe(IScopeContext[] scopes, String qualifier) {
        return new PreferenceObservables(Arrays.asList(scopes), qualifier);
    }

    private PreferenceObservables(List<IScopeContext> scopes, String qualifier) {
        for (IScopeContext scope : scopes) {
            IEclipsePreferences node = scope.getNode(qualifier);
            this.nodes.add(node);
        }
    }

    public IObservableValue<String> observe(String path, String defaultValue) {
        return new AggregateObservableValue<String>(this.nodes, path, String.class, defaultValue){

            @Override
            public String convertToType(String value) {
                return value;
            }
        };
    }

    public IObservableValue<Boolean> observe(String path, Boolean defaultValue) {
        return new AggregateObservableValue<Boolean>(this.nodes, path, Boolean.class, defaultValue){

            @Override
            public Boolean convertToType(String value) {
                return value == null ? null : Boolean.valueOf(value);
            }
        };
    }
}

