/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.databinding.preference.INodeTypingMethods;
import org.eclipse.jface.databinding.preference.NodeObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateObservableValue<T>
extends AbstractObservableValue<T>
implements INodeTypingMethods<T> {
    private List<NodeObserver<T>> observablePreferenceValues;
    private Class<T> valueClass;
    private boolean updating = false;
    private T currentValue;
    private T defaultValue;
    private int numberWithListeners = 0;
    private IValueChangeListener<T> listener = new IValueChangeListener<T>(){

        public void handleValueChange(ValueChangeEvent<T> event) {
            AggregateObservableValue.this.removeAllListeners();
            if (!AggregateObservableValue.this.updating) {
                AggregateObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)AggregateObservableValue.this.currentValue, AggregateObservableValue.this.doGetValue()));
            }
        }
    };

    public AggregateObservableValue(List<IEclipsePreferences> nodes, String path, Class<T> valueClass, T defaultValue) {
        String keyPart;
        String pathPart;
        this.valueClass = valueClass;
        this.valueClass = valueClass;
        this.defaultValue = defaultValue;
        if (path.charAt(0) == '/') {
            throw new IllegalArgumentException("path cannot be absolute, it is relative to each of the root nodes for each scope");
        }
        int indexOfLastSeparator = -1;
        int index = path.indexOf(47);
        while (index != -1) {
            indexOfLastSeparator = index;
            index = path.indexOf(47, indexOfLastSeparator + 1);
        }
        if (indexOfLastSeparator == -1) {
            pathPart = null;
            keyPart = path;
        } else {
            pathPart = path.substring(0, indexOfLastSeparator);
            keyPart = path.substring(indexOfLastSeparator + 1);
        }
        this.observablePreferenceValues = new ArrayList<NodeObserver<T>>();
        for (IEclipsePreferences scopeRootNode : nodes) {
            IEclipsePreferences scopeActualNode = pathPart == null ? scopeRootNode : (IEclipsePreferences)scopeRootNode.node(pathPart);
            this.observablePreferenceValues.add(new NodeObserver<T>(scopeActualNode, keyPart, valueClass, this));
        }
        this.doGetValue();
    }

    public void doSetValue(T value) {
        T oldValue = this.doGetValue();
        try {
            this.updating = true;
        }
        finally {
            this.updating = false;
        }
        this.doGetValue();
        this.fireValueChange(Diffs.createValueDiff(oldValue, value));
    }

    public T doGetValue() {
        this.removeAllListeners();
        for (NodeObserver<T> observableValue : this.observablePreferenceValues) {
            observableValue.addValueChangeListener(this.listener);
            ++this.numberWithListeners;
            if (!observableValue.containsKey()) continue;
            return (T)observableValue.getValue();
        }
        return this.defaultValue;
    }

    public Object getValueType() {
        return this.valueClass;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public synchronized void dispose() {
        this.removeAllListeners();
        super.dispose();
    }

    private void removeAllListeners() {
        int i = 0;
        while (i < this.numberWithListeners) {
            this.observablePreferenceValues.get(i).removeValueChangeListener(this.listener);
            ++i;
        }
        this.numberWithListeners = 0;
    }
}

