/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.ContextStructuredSelection;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.internal.tooltip.TooltipCreator;
import org.eclipse.platform.discovery.ui.internal.tooltip.TreeViewerTooltipManager;
import org.eclipse.platform.discovery.ui.internal.util.ControlBackgroundImageManager;
import org.eclipse.platform.discovery.ui.internal.view.SortingMenuManager;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.DragSrcInteractionListener;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.DragSrcListener;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.LocalSelectionTransferSetter;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.XmlDiscoverySelectionTransferSetter;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.GenericResultContentProvider;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.GenericResultLabelProvider;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class DiscoveryTreeViewerFactory {
    private List<IGenericViewCustomization> availableViewCustomizations;
    private List<IContributedAction> availableActions;
    private IResultsViewAccessor viewAccessor;
    private ControlBackgroundImageManager treeBgImageManager;

    public IResultsViewAccessor createTreeViewer(Composite parent, Set<? extends IGenericViewCustomization> viewCustomizations, Set<IContributedAction> actions, IDiscoveryEnvironment env) {
        this.availableViewCustomizations = new ArrayList<IGenericViewCustomization>(viewCustomizations);
        this.availableActions = new ArrayList<IContributedAction>(actions);
        IToolBarManager toolbarManager = this.createToolbar(parent, 0x4800004);
        TreeViewer treeViewer = this.createTreeViewerInternal(parent, this.contentProvider(this.availableViewCustomizations), this.labelProvider(this.availableViewCustomizations));
        this.installDoubleClickListeners(treeViewer, this.availableViewCustomizations);
        MenuManager menuManager = this.createMenuManager(treeViewer);
        this.viewAccessor = this.viewAccessor(treeViewer, toolbarManager, menuManager);
        this.installDragSupportForResultTreeViewer(this.viewAccessor.getTreeViewer(), env);
        this.installActions(this.availableViewCustomizations, this.availableActions, this.viewAccessor);
        this.installTooltip(this.viewAccessor, this.getGenericResultLabelProvider(viewCustomizations));
        return this.viewAccessor;
    }

    protected IToolBarManager createToolbar(Composite parent, int style) {
        return null;
    }

    private void installTooltip(IResultsViewAccessor va, CellLabelProvider labelProvider) {
        TreeViewerTooltipManager tooltipManager = new TreeViewerTooltipManager(va.getTreeViewer(), labelProvider, new TooltipCreator());
        tooltipManager.install(va.getTreeViewer().getControl());
    }

    private GenericResultLabelProvider getGenericResultLabelProvider(Set<? extends IGenericViewCustomization> viewCustomizations) {
        ArrayList<IGenericViewCustomization> genericViewCustomizations = new ArrayList<IGenericViewCustomization>();
        for (IGenericViewCustomization iGenericViewCustomization : viewCustomizations) {
            genericViewCustomizations.add(iGenericViewCustomization);
        }
        return new GenericResultLabelProvider(genericViewCustomizations);
    }

    private void installDoubleClickListeners(TreeViewer treeViewer, List<IGenericViewCustomization> customizations) {
        for (IGenericViewCustomization viewC : customizations) {
            IDoubleClickListener listener = viewC.getDoubleClickListener();
            if (viewC.getDoubleClickListener() == null) continue;
            treeViewer.addDoubleClickListener(listener);
        }
    }

    protected ILabelProvider labelProvider(List<IGenericViewCustomization> viewCustomizations) {
        return new GenericResultLabelProvider(viewCustomizations);
    }

    protected ITreeContentProvider contentProvider(List<IGenericViewCustomization> viewCustomizations) {
        return new GenericResultContentProvider(viewCustomizations);
    }

    private TreeViewer createTreeViewerInternal(Composite parent, ITreeContentProvider cProvider, ILabelProvider lProvider) {
        final TreeViewer viewer = new TreeViewer(parent, 2);
        viewer.setContentProvider((IContentProvider)cProvider);
        viewer.setLabelProvider((IBaseLabelProvider)lProvider);
        this.treeBgImageManager = new ControlBackgroundImageManager(viewer.getControl());
        this.treeBgImageManager.setBackground(viewer.getControl().getBackground());
        viewer.getControl().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DiscoveryTreeViewerFactory.this.treeBgImageManager.setBackground(viewer.getControl().getBackground());
            }
        });
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DiscoveryTreeViewerFactory.this.dispose();
            }
        });
        return viewer;
    }

    public void dispose() {
        this.treeBgImageManager.disposeResources();
    }

    private void installDragSupportForResultTreeViewer(final TreeViewer viewer, IDiscoveryEnvironment env) {
        int supportedOperations = 3;
        DragSrcListener listener = new DragSrcListener(this.treeViewerSelectionObtainer(viewer), this.supportedTransferDataSetters(env), env.errorHandler()){

            @Override
            public void dragStart(DragSourceEvent event) {
                viewer.getControl().redraw();
                super.dragStart(event);
            }
        };
        viewer.addDragSupport(supportedOperations, listener.getTransfers(), (DragSourceListener)listener);
    }

    protected DragSrcInteractionListener.ISelectionObtainer treeViewerSelectionObtainer(final TreeViewer viewer) {
        return new DragSrcInteractionListener.ISelectionObtainer(){

            @Override
            public IStructuredSelection getSelection() {
                StructuredSelection selection = (StructuredSelection)viewer.getSelection();
                ContextStructuredSelection contextSelection = new ContextStructuredSelection(selection.toList(), (ISearchContext)viewer.getInput());
                return contextSelection;
            }
        };
    }

    protected DragSrcInteractionListener.ITransferDataSetter<? extends Transfer>[] supportedTransferDataSetters(IDiscoveryEnvironment env) {
        LocalSelectionTransferSetter t1 = new LocalSelectionTransferSetter();
        XmlDiscoverySelectionTransferSetter t2 = new XmlDiscoverySelectionTransferSetter(env.operationRunner());
        return new DragSrcInteractionListener.ITransferDataSetter[]{t1, t2};
    }

    private MenuManager createMenuManager(TreeViewer viewer) {
        SortingMenuManager menuManager = new SortingMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DiscoveryTreeViewerFactory.this.installActions(DiscoveryTreeViewerFactory.this.availableViewCustomizations, DiscoveryTreeViewerFactory.this.availableActions, DiscoveryTreeViewerFactory.this.viewAccessor);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        return menuManager;
    }

    private IResultsViewAccessor viewAccessor(final TreeViewer treeViewer, final IToolBarManager toolbarManager, final MenuManager manager) {
        return new IResultsViewAccessor(){

            @Override
            public IToolBarManager getToolbarManager() {
                return toolbarManager;
            }

            @Override
            public TreeViewer getTreeViewer() {
                return treeViewer;
            }

            @Override
            public IMenuManager getMenuManager() {
                return manager;
            }
        };
    }

    private void installActions(List<IGenericViewCustomization> viewCustomizations, List<IContributedAction> actions, IResultsViewAccessor viewAccessor) {
        for (IGenericViewCustomization viewc : viewCustomizations) {
            for (IContributedAction act : actions) {
                viewc.installAction(act, viewAccessor);
            }
        }
    }
}

