/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Snippet001NestedSelectionWithCombo {
    public static void main(String[] args) {
        ViewModel viewModel = new ViewModel();
        Shell shell = new View(viewModel).createShell();
        Display display = Display.getCurrent();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class Person
    extends AbstractModelObject {
        String name;
        String city;

        public Person(String name, String city) {
            this.name = name;
            this.city = city;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            String oldValue = this.city;
            this.city = city;
            this.firePropertyChange("city", oldValue, city);
        }
    }

    static class View {
        private ViewModel viewModel;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Shell shell = new Shell(Display.getCurrent());
            Realm realm = SWTObservables.getRealm((Display)shell.getDisplay());
            List peopleList = new List((Composite)shell, 2048);
            Text name = new Text((Composite)shell, 2048);
            Combo city = new Combo((Composite)shell, 2056);
            ListViewer peopleListViewer = new ListViewer(peopleList);
            IObservableMap attributeMap = BeansObservables.observeMap((IObservableSet)Observables.staticObservableSet((Realm)realm, new HashSet(this.viewModel.getPeople())), Person.class, (String)"name");
            peopleListViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributeMap));
            peopleListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            peopleListViewer.setInput((Object)this.viewModel.getPeople());
            DataBindingContext dbc = new DataBindingContext(realm);
            IViewerObservableValue selectedPerson = ViewersObservables.observeSingleSelection((Viewer)peopleListViewer);
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Text)name, (int)24), BeansObservables.observeDetailValue((IObservableValue)selectedPerson, (String)"name", String.class));
            ComboViewer cityViewer = new ComboViewer(city);
            cityViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            cityViewer.setInput((Object)this.viewModel.getCities());
            IViewerObservableValue citySelection = ViewersObservables.observeSingleSelection((Viewer)cityViewer);
            dbc.bindValue((IObservableValue)citySelection, BeansObservables.observeDetailValue((IObservableValue)selectedPerson, (String)"city", String.class));
            GridLayoutFactory.swtDefaults().applyTo((Composite)shell);
            shell.pack();
            shell.open();
            return shell;
        }
    }

    static class ViewModel
    extends AbstractModelObject {
        private ArrayList people = new ArrayList();
        private ArrayList cities;

        ViewModel() {
            this.people.add(new Person("Wile E. Coyote", "Tucson"));
            this.people.add(new Person("Road Runner", "Lost Horse"));
            this.people.add(new Person("Bugs Bunny", "Forrest"));
            this.cities = new ArrayList();
            this.cities.add("Tucson");
            this.cities.add("AcmeTown");
            this.cities.add("Lost Horse");
            this.cities.add("Forrest");
            this.cities.add("Lost Mine");
        }

        public ArrayList getPeople() {
            return this.people;
        }

        public ArrayList getCities() {
            return this.cities;
        }
    }
}

