/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.wizard;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class AddUrlResourceNameAndURLPage
extends WizardPage {
    IContainer myContainer;
    private Text parentText;
    private Text childText;
    private Text urlText;
    private Button forceOverwrite;

    public AddUrlResourceNameAndURLPage() {
        super(AddUrlResourceNameAndURLPage.class.getName());
        this.setTitle(Messages.AddUrlResourceNameAndURLPage_PageTitle_XGRP);
    }

    public void setResourceContainer(IContainer container) {
        this.myContainer = container;
        if (this.myContainer != null) {
            if (this.myContainer.getAdapter(ISemanticResource.class) == null) {
                this.setMessage(Messages.AddUrlResourceNameAndURLPage_NotSemanticParent_XMSG);
            } else {
                this.setMessage(Messages.AddUrlResourceNameAndURLPage_SemanticParent_XMSG);
            }
            if (this.parentText != null) {
                this.parentText.setText(this.myContainer.getFullPath().toString());
            }
        }
    }

    public IContainer getResourceContainer() {
        return this.myContainer;
    }

    public boolean getForceOverwrite() {
        return this.forceOverwrite.getSelection();
    }

    public void createControl(Composite parent) {
        this.setMessage(Messages.AddUrlResourceNameAndURLPage_SelectFolderNameURL_XMSG);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        new Label(main, 0).setText(Messages.AddUrlResourceNameAndURLPage_Parent_XFLD);
        this.parentText = new Text(main, 2048);
        if (this.myContainer != null) {
            this.parentText.setText(this.myContainer.getFullPath().toString());
        }
        this.parentText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parentText);
        Button browseButton = new Button(main, 8);
        browseButton.setText(Messages.AddUrlResourceNameAndURLPage_Browse_XBUT);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog csd = new ContainerSelectionDialog(AddUrlResourceNameAndURLPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.AddUrlResourceNameAndURLPage_SelectFolder_XGRP);
                csd.setValidator(new ISelectionValidator(){

                    public String isValid(Object selection) {
                        IPath path = (IPath)selection;
                        if (path.segmentCount() > 1) {
                            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                            if (folder.isLinked()) {
                                return Messages.AddUrlResourceNameAndURLPage_NoLinkAllowed_XMSG;
                            }
                            return null;
                        }
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        if (project.isLinked()) {
                            return Messages.AddUrlResourceNameAndURLPage_NoLinkAllowed_XMSG;
                        }
                        return null;
                    }
                });
                if (csd.open() == 0) {
                    Object[] result = csd.getResult();
                    IPath path = (IPath)result[0];
                    if (path.segmentCount() > 1) {
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                        AddUrlResourceNameAndURLPage.this.setResourceContainer((IContainer)folder);
                    } else {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        AddUrlResourceNameAndURLPage.this.setResourceContainer((IContainer)project);
                    }
                    AddUrlResourceNameAndURLPage.this.checkPage();
                }
            }
        });
        new Label(main, 0).setText(Messages.AddUrlResourceNameAndURLPage_Name_XFLD);
        this.childText = new Text(main, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.childText);
        this.childText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddUrlResourceNameAndURLPage.this.checkPage();
            }
        });
        new Label(main, 0).setText(Messages.AddUrlResourceNameAndURLPage_Url_XFLD);
        this.urlText = new Text(main, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.urlText);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddUrlResourceNameAndURLPage.this.checkPage();
            }
        });
        this.forceOverwrite = new Button(main, 32);
        this.forceOverwrite.setText(Messages.AddUrlResourceNameAndURLPage_Overwrite_XFLD);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.forceOverwrite);
        this.forceOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddUrlResourceNameAndURLPage.this.checkPage();
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)main);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkPage() {
        block15: {
            this.setErrorMessage(null);
            this.setMessage(null, 2);
            if (this.myContainer == null) {
                this.setErrorMessage(Messages.AddUrlResourceNameAndURLPage_SelectFolder_XMSG);
            }
            ** GOTO lbl-1000
            {
                block14: {
                    catch (Throwable var4_4) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw var4_4;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (this.childText.getText().length() != 0) ** GOTO lbl-1000
                        this.setErrorMessage(Messages.AddUrlResourceNameAndURLPage_SelectChildName_XMSG);
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (!this.myContainer.exists((IPath)new Path(this.childText.getText()))) ** GOTO lbl-1000
                        if (this.forceOverwrite.getSelection()) {
                            this.setMessage(NLS.bind((String)Messages.AddUrlResourceNameAndURLPage_WillOverwrite_XMSG, (Object)this.childText.getText()), 2);
                        } else {
                            this.setErrorMessage(NLS.bind((String)Messages.AddUrlResourceNameAndURLPage_ChildExists_XMSG, (Object)this.childText.getText()));
                        }
                        this.forceOverwrite.setEnabled(true);
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        valid = ResourcesPlugin.getWorkspace().validateName(this.childText.getText(), 1);
                        if (valid.isOK()) break block14;
                        this.setErrorMessage(valid.getMessage());
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                try {
                    childPath = this.myContainer.getFullPath().append(this.childText.getText()).toString();
                    sfsUri = new URI("semanticfs", null, childPath, null);
                    if (!EFS.getStore((URI)sfsUri).fetchInfo().exists()) ** GOTO lbl45
                    if (this.forceOverwrite.getSelection()) {
                        this.setMessage(NLS.bind((String)Messages.AddUrlResourceNameAndURLPage_WillOverwriteStore_XMSG, (Object)sfsUri.toString()), 2);
                    } else {
                        this.setErrorMessage(NLS.bind((String)Messages.AddUrlResourceNameAndURLPage_StoreExists_XMSG, (Object)sfsUri.toString()));
                    }
                    this.forceOverwrite.setEnabled(true);
                }
                catch (URISyntaxException v0) {}
                this.setPageComplete(this.getErrorMessage() == null);
                return;
                {
                    block16: {
                        break block16;
                        catch (CoreException v1) {}
                    }
                    if (this.urlText.getText().length() != 0) break block15;
                    this.setErrorMessage(Messages.AddUrlResourceNameAndURLPage_MissingURL_XMSG);
                }
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public String getChildName() {
        return this.childText.getText();
    }

    public String getUrl() {
        return this.urlText.getText();
    }
}

