/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui;

import java.util.Collection;
import org.eclipse.platform.discovery.destprefs.internal.i18n.DestPrefsMessages;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationProviderPair;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationsPreferencePage;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsPresenter;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsView;
import org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui.CategoryPageObject;
import org.eclipse.platform.discovery.destprefs.test.unit.prefpage.ui.DestinationPageObject;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DestinationsPreferencePagePageObject
extends InShellPageObject {
    private final IDestinationConfiguratorsPresenter presenter;
    private DestinationsPreferencePage page;

    public DestinationsPreferencePagePageObject(IDestinationConfiguratorsPresenter presenter) {
        this.presenter = presenter;
    }

    protected void createContent(Shell parent, FormToolkit formToolkit) {
        this.page = new DestinationsPreferencePage(this.presenter);
        this.page.createControl((Composite)parent);
    }

    public IDestinationConfiguratorsView getView() {
        return this.page;
    }

    public boolean canAddDestination() {
        return this.addDestinationButton().isEnabled();
    }

    public void addDestination() {
        this.addDestinationButton().click();
    }

    public boolean canEditDestination() {
        return this.editDestinationButton().isEnabled();
    }

    public void editDestination() {
        this.editDestinationButton().click();
    }

    public boolean canRemoveDestination() {
        return this.removeDestinationButton().isEnabled();
    }

    public void removeDestination() {
        this.removeDestinationButton().click();
    }

    public boolean canTestDestination() {
        return this.testDestinationButton().isEnabled();
    }

    public void testDestination() {
        this.testDestinationButton().click();
    }

    public CategoryPageObject getCategory(String categoryName) {
        return new CategoryPageObject(this.categoryTreeItem(categoryName));
    }

    private SWTBotTreeItem categoryTreeItem(String category) {
        SWTBotTreeItem[] sWTBotTreeItemArray = this.destinationsTree().getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            if (item.getText().startsWith(category)) {
                return item;
            }
            ++n2;
        }
        throw new RuntimeException("Could not find category " + category);
    }

    public DestinationPageObject getDestination(String categoryName, String destinationName) {
        return this.getCategory(categoryName).getDestination(destinationName);
    }

    public int getMessageType() {
        return this.page.getMessageType();
    }

    public String getMessage() {
        return this.page.getMessage();
    }

    public void setInput(final Collection<CategoryDestinationProviderPair> input) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                DestinationsPreferencePagePageObject.this.page.setInput(input);
            }
        });
    }

    public void setAddEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                DestinationsPreferencePagePageObject.this.page.setAddEnabled(enabled);
            }
        });
    }

    public void setEditEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                DestinationsPreferencePagePageObject.this.page.setEditEnabled(enabled);
            }
        });
    }

    public void setRemoveEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                DestinationsPreferencePagePageObject.this.page.setRemoveEnabled(enabled);
            }
        });
    }

    public void setTestEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                DestinationsPreferencePagePageObject.this.page.setTestEnabled(enabled);
            }
        });
    }

    public String getDisplayedStatus() {
        return this.bot().clabel().getText();
    }

    private SWTBotTree destinationsTree() {
        return this.bot().tree();
    }

    private SWTBotButton addDestinationButton() {
        return this.bot().button(DestPrefsMessages.DestinationsPrefPage_AddButton);
    }

    private SWTBotButton removeDestinationButton() {
        return this.bot().button(DestPrefsMessages.DestinationsPrefPage_DeleteButton);
    }

    private SWTBotButton editDestinationButton() {
        return this.bot().button(DestPrefsMessages.DestinationsPrefPage_EditButton);
    }

    private SWTBotButton testDestinationButton() {
        return this.bot().button(DestPrefsMessages.DestinationsPrefPage_TestButton);
    }
}

