/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common.component;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public class IdGenerator {
    private IValueChangeListener listener;
    private IObservableValue observableValue;
    protected boolean ignore;
    private IValueChangeListener listener2;
    private IObservableValue observableValue2;
    static Pattern patternId = Pattern.compile("^(.*\\.)\\d+$");

    public void bind(final IObservableValue master, final IEMFEditValueProperty ebpLabel, final IEMFEditValueProperty evpId, Control control) {
        Matcher m;
        String origLabel = (String)ebpLabel.getValue(master.getValue());
        if (E.notEmpty(origLabel)) {
            this.stopGenerating();
            return;
        }
        String origId = (String)evpId.getValue(master.getValue());
        if (origId == null) {
            origId = "id.0";
        }
        if (!(m = patternId.matcher(origId)).matches()) {
            this.stopGenerating();
            return;
        }
        final String baseId = m.group(1);
        if (control != null) {
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    IdGenerator.this.stopGenerating();
                }
            });
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    IdGenerator.this.stopGenerating();
                }
            });
        }
        this.observableValue2 = evpId.observe(master.getValue());
        this.listener2 = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (!IdGenerator.this.ignore) {
                    IdGenerator.this.stopGenerating();
                }
            }
        };
        this.observableValue2.addValueChangeListener(this.listener2);
        this.observableValue = ebpLabel.observe(master.getValue());
        this.listener = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                String labelValue = (String)ebpLabel.getValue(master.getValue());
                if (labelValue == null) {
                    labelValue = "";
                }
                String camelCase = IdGenerator.camelCase(labelValue);
                IdGenerator.this.ignore = true;
                evpId.setValue(master.getValue(), (Object)(String.valueOf(baseId) + camelCase));
                IdGenerator.this.ignore = false;
            }
        };
        this.observableValue.addValueChangeListener(this.listener);
    }

    protected static String camelCase(String value) {
        String[] parts = value.split("\\s+");
        String ret = "";
        boolean first = true;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            part = part.replaceAll("[^0-9a-zA-Z_-]", "");
            if (first) {
                first = false;
                ret = part.toLowerCase();
            } else {
                part = String.valueOf(part.substring(0, 1).toUpperCase()) + part.substring(1).toLowerCase();
                ret = String.valueOf(ret) + part;
            }
            ++n2;
        }
        return ret;
    }

    public void stopGenerating() {
        if (this.observableValue != null) {
            this.observableValue.removeValueChangeListener(this.listener);
            this.listener = null;
            this.observableValue = null;
        }
        if (this.observableValue2 != null) {
            this.observableValue2.removeValueChangeListener(this.listener2);
            this.listener2 = null;
            this.observableValue2 = null;
        }
    }
}

