/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PojoObservables {
    public static <S> IObservableValue<?> observeValue(S pojo, String propertyName) {
        return PojoObservables.observeValue(Realm.getDefault(), pojo, propertyName);
    }

    public static <S> IObservableValue<?> observeValue(Realm realm, S pojo, String propertyName) {
        return PojoObservables.observeValue(realm, Util.getClass(pojo), pojo, propertyName);
    }

    private static <S, S2 extends S> IObservableValue<?> observeValue(Realm realm, Class<S2> pojoClass, S pojo, String propertyName) {
        return PojoProperties.value(pojoClass, propertyName).observe(realm, pojoClass.cast(pojo));
    }

    public static <S> IObservableMap<S, Object> observeMap(IObservableSet<S> domain, String propertyName) {
        return PojoProperties.value(propertyName).observeDetail(domain);
    }

    public static <S> IObservableMap<S, ?> observeMap(IObservableSet<S> domain, Class<S> pojoClass, String propertyName) {
        return PojoProperties.value(pojoClass, propertyName).observeDetail(domain);
    }

    public static <S> IObservableMap<?, ?>[] observeMaps(IObservableSet<S> domain, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = PojoObservables.observeMap(domain, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static <S> List<IObservableMap<S, ?>> observeMaps2(IObservableSet<S> domain, String[] propertyNames) {
        ArrayList result = new ArrayList(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            result.add(PojoObservables.observeMap(domain, propertyNames[i]));
            ++i;
        }
        return result;
    }

    public static <S> IObservableMap<?, ?>[] observeMaps(IObservableSet<S> domain, Class<S> pojoClass, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = PojoObservables.observeMap(domain, pojoClass, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static <S> List<IObservableMap<S, ?>> observeMaps2(IObservableSet<S> domain, Class<S> pojoClass, String[] propertyNames) {
        ArrayList result = new ArrayList(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            result.add(PojoObservables.observeMap(domain, pojoClass, propertyNames[i]));
            ++i;
        }
        return result;
    }

    public static <S> IObservableMap<?, ?> observeMap(Realm realm, S pojo, String propertyName) {
        return PojoObservables.observeMap(realm, pojo, propertyName, null, null);
    }

    public static <S, K, V> IObservableMap<K, V> observeMap(Realm realm, S pojo, String propertyName, Class<K> keyType, Class<V> valueType) {
        return PojoProperties.map(pojo.getClass(), propertyName, keyType, valueType).observe(realm, pojo);
    }

    public static <S> IObservableMap<?, ?> observeMap(S pojo, String propertyName) {
        return PojoObservables.observeMap(Realm.getDefault(), pojo, propertyName, null, null);
    }

    public static <S, K, V> IObservableMap<K, V> observeMap(S pojo, String propertyName, Class<K> keyType, Class<V> valueType) {
        return PojoObservables.observeMap(Realm.getDefault(), pojo, propertyName, keyType, valueType);
    }

    public static <S> IObservableList<?> observeList(Realm realm, S pojo, String propertyName) {
        return PojoObservables.observeList(realm, pojo, propertyName, null);
    }

    public static <S> IObservableList<?> observeList(S pojo, String propertyName) {
        return PojoObservables.observeList(Realm.getDefault(), pojo, propertyName);
    }

    public static <S, E> IObservableList<E> observeList(Realm realm, S pojo, String propertyName, Class<E> elementType) {
        return PojoProperties.list(pojo.getClass(), propertyName, elementType).observe(realm, pojo);
    }

    public static <S, E> IObservableList<E> observeList(S pojo, String propertyName, Class<E> elementType) {
        return PojoObservables.observeList(Realm.getDefault(), pojo, propertyName, elementType);
    }

    public static <S> IObservableSet<?> observeSet(Realm realm, S pojo, String propertyName) {
        return PojoObservables.observeSet(realm, pojo, propertyName, null);
    }

    public static <S> IObservableSet<?> observeSet(S pojo, String propertyName) {
        return PojoObservables.observeSet(Realm.getDefault(), pojo, propertyName);
    }

    public static <S, E> IObservableSet<E> observeSet(Realm realm, S pojo, String propertyName, Class<E> elementType) {
        return PojoProperties.set(pojo.getClass(), propertyName, elementType).observe(realm, pojo);
    }

    public static <S, E> IObservableSet<E> observeSet(S pojo, String propertyName, Class<E> elementType) {
        return PojoObservables.observeSet(Realm.getDefault(), pojo, propertyName, elementType);
    }

    public static IObservableFactory<Object, IObservableValue<Object>> valueFactory(Realm realm, String propertyName) {
        return PojoProperties.value(propertyName).valueFactory(realm);
    }

    public static IObservableFactory<Object, IObservableValue<Object>> valueFactory(String propertyName) {
        return PojoObservables.valueFactory(Realm.getDefault(), propertyName);
    }

    public static <E> IObservableFactory<Object, IObservableList<E>> listFactory(Realm realm, String propertyName, Class<E> elementType) {
        return PojoProperties.list(propertyName, elementType).listFactory(realm);
    }

    public static <E> IObservableFactory<Object, IObservableList<E>> listFactory(String propertyName, Class<E> elementType) {
        return PojoObservables.listFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory<Object, IObservableSet<Object>> setFactory(Realm realm, String propertyName) {
        return PojoProperties.set(propertyName).setFactory(realm);
    }

    public static IObservableFactory<Object, IObservableSet<Object>> setFactory(String propertyName) {
        return PojoObservables.setFactory(Realm.getDefault(), propertyName);
    }

    public static <E> IObservableFactory<Object, IObservableSet<E>> setFactory(Realm realm, String propertyName, Class<E> elementType) {
        return PojoProperties.set(propertyName, elementType).setFactory(realm);
    }

    public static <E> IObservableFactory<Object, IObservableSet<E>> setFactory(String propertyName, Class<E> elementType) {
        return PojoObservables.setFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory<Object, IObservableMap<Object, Object>> mapPropertyFactory(Realm realm, String propertyName) {
        return PojoProperties.map(propertyName).mapFactory(realm);
    }

    public static IObservableFactory<Object, IObservableMap<Object, Object>> mapPropertyFactory(String propertyName) {
        return PojoObservables.mapPropertyFactory(Realm.getDefault(), propertyName);
    }

    public static <M, T> IObservableValue<T> observeDetailValue(Realm realm, IObservableValue<M> master, String propertyName, Class<T> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableValue value = MasterDetailObservables.detailValue(master, (IObservableFactory)PojoProperties.value(propertyName, propertyType).valueFactory(realm), propertyType);
        return new BeanObservableValueDecorator(value, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M, T> IObservableValue<T> observeDetailValue(IObservableValue<M> master, String propertyName, Class<T> propertyType) {
        return PojoProperties.value(master.getValueClass(), propertyName, propertyType).observeDetail(master);
    }

    public static <M, E> IObservableList<E> observeDetailList(Realm realm, IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableList observableList = MasterDetailObservables.detailList(master, (IObservableFactory)PojoProperties.list(propertyName, propertyType).listFactory(realm), propertyType);
        return new BeanObservableListDecorator(observableList, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M, E> IObservableList<E> observeDetailList(IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        return PojoProperties.list(master.getValueClass(), propertyName).observeDetail(master);
    }

    public static <M, E> IObservableSet<E> observeDetailSet(Realm realm, IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableSet observableSet = MasterDetailObservables.detailSet(master, (IObservableFactory)PojoProperties.set(propertyName, propertyType).setFactory(realm), propertyType);
        return new BeanObservableSetDecorator(observableSet, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M, E> IObservableSet<E> observeDetailSet(IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        return PojoProperties.set(master.getValueClass(), propertyName, propertyType).observeDetail(master);
    }

    public static <M> IObservableMap<Object, Object> observeDetailMap(Realm realm, IObservableValue<M> master, String propertyName) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableMap observableMap = MasterDetailObservables.detailMap(master, (IObservableFactory)PojoProperties.map(propertyName).mapFactory(realm));
        return new BeanObservableMapDecorator(observableMap, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M> IObservableMap<Object, Object> observeDetailMap(IObservableValue<M> master, String propertyName) {
        return PojoProperties.map(master.getValueClass(), propertyName).observeDetail(master);
    }
}

