/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPropertyDetailValuesList<S, T, E>
extends ListProperty<S, E> {
    private final IListProperty<S, T> masterProperty;
    private final IValueProperty<? super T, E> detailProperty;

    public ListPropertyDetailValuesList(IListProperty<S, T> masterProperty, IValueProperty<? super T, E> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getElementType() {
        return this.detailProperty.getValueType();
    }

    @Override
    public Class<E> getElementClass() {
        return this.detailProperty.getValueClass();
    }

    @Override
    protected List<E> doGetList(S source) {
        List<T> masterList = this.masterProperty.getList(source);
        ArrayList<E> detailList = new ArrayList<E>(masterList.size());
        Iterator<T> it = masterList.iterator();
        while (it.hasNext()) {
            detailList.add(this.detailProperty.getValue(it.next()));
        }
        return detailList;
    }

    @Override
    protected void doUpdateList(S source, ListDiff<E> diff) {
        final List<T> masterList = this.masterProperty.getList(source);
        diff.accept(new ListDiffVisitor<E>(){

            public void handleAdd(int index, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleRemove(int index, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleMove(int oldIndex, int newIndex, E element) {
                throw new UnsupportedOperationException();
            }

            public void handleReplace(int index, E oldElement, E newElement) {
                ListPropertyDetailValuesList.this.detailProperty.setValue(masterList.get(index), newElement);
            }
        });
    }

    @Override
    public IObservableList<E> observe(Realm realm, S source) {
        IObservableList<T> masterList;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterList = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableList<E> detailList = this.detailProperty.observeDetail(masterList);
        PropertyObservableUtil.cascadeDispose(detailList, masterList);
        return detailList;
    }

    @Override
    public <U extends S> IObservableList<E> observeDetail(IObservableValue<U> master) {
        IObservableList<T> masterList;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterList = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableList<E> detailList = this.detailProperty.observeDetail(masterList);
        PropertyObservableUtil.cascadeDispose(detailList, masterList);
        return detailList;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

