/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.set;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.property.SetPropertyDetailValuesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetProperty<S, E>
implements ISetProperty<S, E> {
    @Override
    public Set<E> getSet(S source) {
        if (source == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.doGetSet(source));
    }

    protected Set<E> doGetSet(S source) {
        IObservableSet<E> observable = this.observe(source);
        try {
            IdentitySet identitySet = new IdentitySet(observable);
            return identitySet;
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public final void setSet(S source, Set<E> set) {
        if (source != null) {
            this.doSetSet(source, set);
        }
    }

    protected void doSetSet(S source, Set<E> set) {
        this.doUpdateSet(source, Diffs.computeSetDiff(this.doGetSet(source), set));
    }

    @Override
    public final void updateSet(S source, SetDiff<E> diff) {
        if (source != null && !diff.isEmpty()) {
            this.doUpdateSet(source, diff);
        }
    }

    protected void doUpdateSet(S source, SetDiff<E> diff) {
        IObservableSet<E> observable = this.observe(source);
        try {
            diff.applyTo(observable);
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public IObservableSet<E> observe(S source) {
        return this.observe(Realm.getDefault(), source);
    }

    @Override
    public IObservableFactory<S, IObservableSet<E>> setFactory() {
        return new IObservableFactory<S, IObservableSet<E>>(){

            public IObservableSet<E> createObservable(S target) {
                return SetProperty.this.observe(target);
            }
        };
    }

    @Override
    public IObservableFactory<S, IObservableSet<E>> setFactory(final Realm realm) {
        return new IObservableFactory<S, IObservableSet<E>>(){

            public IObservableSet<E> createObservable(S target) {
                return SetProperty.this.observe(realm, target);
            }
        };
    }

    @Override
    public <U extends S> IObservableSet<E> observeDetail(IObservableValue<U> master) {
        return MasterDetailObservables.detailSet(master, this.setFactory(master.getRealm()), this.getElementClass());
    }

    @Override
    public final <T> IMapProperty<S, E, T> values(IValueProperty<? super E, T> detailValues) {
        return new SetPropertyDetailValuesMap(this, detailValues);
    }

    @Override
    public Class<E> getElementClass() {
        Object elementType = this.getElementType();
        if (elementType instanceof Class) {
            return (Class)elementType;
        }
        return null;
    }
}

