/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.list;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.databinding.property.list.SimpleListProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingListProperty<S, E>
extends ListProperty<S, E> {
    private final IListProperty<S, E> nullProperty;
    private final Class<E> elementType;
    private final Object elementTypeAsObject;

    protected DelegatingListProperty() {
        this(null);
    }

    protected DelegatingListProperty(Object elementType) {
        this.elementType = null;
        this.elementTypeAsObject = elementType;
        this.nullProperty = new NullListProperty();
    }

    protected DelegatingListProperty(Class<E> elementType) {
        this.elementType = elementType;
        this.elementTypeAsObject = elementType;
        this.nullProperty = new NullListProperty();
    }

    public final IListProperty<S, E> getDelegate(S source) {
        if (source == null) {
            return this.nullProperty;
        }
        IListProperty<S, E> delegate = this.doGetDelegate(source);
        if (delegate == null) {
            delegate = this.nullProperty;
        }
        return delegate;
    }

    protected abstract IListProperty<S, E> doGetDelegate(S var1);

    @Override
    public Object getElementType() {
        return this.elementTypeAsObject;
    }

    @Override
    public Class<E> getElementClass() {
        return this.elementType;
    }

    @Override
    protected List<E> doGetList(S source) {
        return this.getDelegate(source).getList(source);
    }

    @Override
    protected void doSetList(S source, List<E> list) {
        this.getDelegate(source).setList(source, list);
    }

    @Override
    protected void doUpdateList(S source, ListDiff<E> diff) {
        this.getDelegate(source).updateList(source, diff);
    }

    @Override
    public IObservableList<E> observe(S source) {
        return this.getDelegate(source).observe(source);
    }

    @Override
    public IObservableList<E> observe(Realm realm, S source) {
        return this.getDelegate(source).observe(realm, source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NullListProperty
    extends SimpleListProperty<S, E> {
        private NullListProperty() {
        }

        @Override
        public Object getElementType() {
            return DelegatingListProperty.this.elementTypeAsObject;
        }

        @Override
        public Class<E> getElementClass() {
            return DelegatingListProperty.this.elementType;
        }

        @Override
        protected List<E> doGetList(S source) {
            return Collections.emptyList();
        }

        @Override
        protected void doSetList(S source, List<E> list, ListDiff<E> diff) {
        }

        @Override
        protected void doSetList(S source, List<E> list) {
        }

        @Override
        protected void doUpdateList(S source, ListDiff<E> diff) {
        }

        @Override
        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<ListDiff<E>> listener) {
            return null;
        }
    }
}

