/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import java.util.ArrayList;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.internal.databinding.provisional.bind.IOneWayModelBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITargetBinding;
import org.eclipse.core.internal.databinding.provisional.bind.OneWayBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayTrackedConversionBinding<T2, T1>
extends OneWayBinding<T2>
implements ITargetBinding<T1> {
    private final IOneWayModelBinding<T1> modelBinding;
    private final IConverter<T1, T2> converter;
    private IObservable[] dependencies = null;
    private IChangeListener privateChangeInterface = new PrivateChangeInterface();

    public OneWayTrackedConversionBinding(IOneWayModelBinding<T1> modelBinding, IConverter<T1, T2> converter) {
        this.modelBinding = modelBinding;
        this.converter = converter;
    }

    @Override
    public T2 getModelValue() {
        T1 modelValue = this.modelBinding.getModelValue();
        return this.convertAndTrack(modelValue);
    }

    @Override
    public void setTargetValue(T1 valueOnModelSide) {
        T2 valueOnTargetSide = this.convertAndTrack(valueOnModelSide);
        this.targetBinding.setTargetValue(valueOnTargetSide);
    }

    private T2 convertAndTrack(final T1 valueOnModelSide) {
        this.stopListening();
        final ArrayList valueOnTargetSide = new ArrayList();
        Runnable privateRunnableInterface = new Runnable(){

            public void run() {
                valueOnTargetSide.add(OneWayTrackedConversionBinding.this.converter.convert(valueOnModelSide));
            }
        };
        IObservable[] newDependencies = ObservableTracker.runAndMonitor((Runnable)privateRunnableInterface, (IChangeListener)this.privateChangeInterface, null);
        this.dependencies = newDependencies;
        return (T2)valueOnTargetSide.get(0);
    }

    private void stopListening() {
        if (this.dependencies != null) {
            IObservable[] iObservableArray = this.dependencies;
            int n = this.dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable observable = iObservableArray[n2];
                observable.removeChangeListener(this.privateChangeInterface);
                ++n2;
            }
            this.dependencies = null;
        }
    }

    @Override
    public void removeModelListener() {
        this.modelBinding.removeModelListener();
    }

    private class PrivateChangeInterface
    implements IChangeListener {
        private PrivateChangeInterface() {
        }

        public void handleChange(ChangeEvent event) {
            Object valueFromModelSide = OneWayTrackedConversionBinding.this.modelBinding.getModelValue();
            OneWayTrackedConversionBinding.this.setTargetValue(valueFromModelSide);
        }
    }
}

