/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal.contributors.impl;

import java.util.Collection;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.DynamicRegistryContributor;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.IdCalculator;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.searchprovider.CompatibilitySearchProvider;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageDescription;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageParser;
import org.w3c.dom.Element;

public class DynamicSearchProviderContributor
extends DynamicRegistryContributor<ISearchPageDescription> {
    private final IdCalculator idCalculator = new IdCalculator();

    public DynamicSearchProviderContributor(ISearchPageParser contributionsReader) {
        super(contributionsReader, "org.eclipse.platform.discovery.runtime.searchprovider", "searchprovider");
    }

    @Override
    protected String getFailureMessage(Collection<ISearchPageDescription> failedContributors) {
        return "Dynamic search provider contribution failed for the following search pages" + failedContributors;
    }

    @Override
    protected String getContributionDescription(ISearchPageDescription data) {
        return "Dynamic search provider for search page:" + data;
    }

    @Override
    protected void configureTargetElement(Element element, ISearchPageDescription data) {
        element.setAttribute("id", this.idCalculator.calculateSearchProviderId(data));
        element.setAttribute("objecttypeid", this.idCalculator.calculateObjectTypeId(data));
        element.setAttribute("instance", CompatibilitySearchProvider.class.getName());
    }
}

