/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.context.spy;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.internal.tools.context.spy.ContextDataProvider;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ContextDataPart {
    private TreeViewer contextDataViewer;
    private ContextDataProvider dataProvider;
    private ContextEntryComparator comparator;
    private static final ViewerFilter[] NO_FILTER = new ViewerFilter[0];

    @PostConstruct
    public void createControls(Composite parent, IEclipseContext ctx) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.contextDataViewer = new TreeViewer(parent);
        this.dataProvider = (ContextDataProvider)((Object)ContextInjectionFactory.make(ContextDataProvider.class, (IEclipseContext)ctx));
        this.contextDataViewer.setContentProvider((IContentProvider)this.dataProvider);
        this.contextDataViewer.setLabelProvider((IBaseLabelProvider)this.dataProvider);
        Tree cTree = this.contextDataViewer.getTree();
        cTree.setHeaderVisible(true);
        cTree.setLinesVisible(true);
        cTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contextDataViewer.setInput((Object)"Foo");
        TreeViewerColumn keyCol = new TreeViewerColumn(this.contextDataViewer, 0);
        keyCol.getColumn().setWidth(400);
        keyCol.getColumn().setText("Key");
        ContextDataProvider keyLabelProvider = (ContextDataProvider)((Object)ContextInjectionFactory.make(ContextDataProvider.class, (IEclipseContext)ctx));
        keyLabelProvider.setDisplayKey(true);
        keyCol.setLabelProvider((CellLabelProvider)keyLabelProvider);
        keyCol.getColumn().setToolTipText("Key in context");
        keyCol.getColumn().addSelectionListener((SelectionListener)this.getHeaderSelectionAdapter(this.contextDataViewer, keyCol.getColumn(), 0, (ILabelProvider)keyLabelProvider));
        this.comparator = new ContextEntryComparator(0, (ILabelProvider)keyLabelProvider);
        this.contextDataViewer.setComparator((ViewerComparator)this.comparator);
        TreeViewerColumn valueCol = new TreeViewerColumn(this.contextDataViewer, 0);
        valueCol.getColumn().setWidth(600);
        valueCol.getColumn().setText("Value");
        ContextDataProvider valueLabelProvider = (ContextDataProvider)((Object)ContextInjectionFactory.make(ContextDataProvider.class, (IEclipseContext)ctx));
        valueCol.setLabelProvider((CellLabelProvider)this.dataProvider);
        valueCol.getColumn().addSelectionListener((SelectionListener)this.getHeaderSelectionAdapter(this.contextDataViewer, valueCol.getColumn(), 1, (ILabelProvider)valueLabelProvider));
        this.contextDataViewer.expandAll();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.contextDataViewer);
    }

    @PreDestroy
    public void dispose() {
    }

    @Focus
    public void setFocus() {
        this.contextDataViewer.getControl().setFocus();
    }

    @Inject
    @Optional
    public void listenToContext(@Named(value="org.eclipse.ui.selection") EclipseContext ctx) {
        if (ctx == null || this.contextDataViewer == null) {
            return;
        }
        this.contextDataViewer.setInput((Object)ctx);
        this.contextDataViewer.expandToLevel(2);
    }

    private SelectionAdapter getHeaderSelectionAdapter(final TreeViewer viewer, final TreeColumn column, final int columnIndex, final ILabelProvider textProvider) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                viewer.setComparator((ViewerComparator)ContextDataPart.this.comparator);
                ContextDataPart.this.comparator.setColumn(columnIndex);
                ContextDataPart.this.comparator.setLabelProvider(textProvider);
                viewer.getTree().setSortDirection(ContextDataPart.this.comparator.getDirection());
                viewer.getTree().setSortColumn(column);
                viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void refresh(boolean refreshLabel) {
        this.contextDataViewer.refresh(refreshLabel);
    }

    public void setFilter(ViewerFilter filter) {
        ViewerFilter[] viewerFilterArray;
        if (filter == null) {
            viewerFilterArray = NO_FILTER;
        } else {
            ViewerFilter[] viewerFilterArray2 = new ViewerFilter[1];
            viewerFilterArray = viewerFilterArray2;
            viewerFilterArray2[0] = filter;
        }
        this.contextDataViewer.setFilters(viewerFilterArray);
    }

    public class ContextEntryComparator
    extends ViewerComparator {
        private int columnIndex;
        private int direction;
        private ILabelProvider labelProvider;

        public ContextEntryComparator(int columnIndex, ILabelProvider defaultLabelProvider) {
            this.columnIndex = columnIndex;
            this.direction = 128;
            this.labelProvider = defaultLabelProvider;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setColumn(int column) {
            if (column == this.columnIndex) {
                this.direction = this.direction == 128 ? 1024 : 128;
            } else {
                this.columnIndex = column;
                this.direction = 1024;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 == "Local values managed  by this context" || e2 == "Local values managed  by this context") {
                return -1;
            }
            String lp1 = this.labelProvider.getText(e1);
            String lp2 = this.labelProvider.getText(e2);
            String s1 = lp1 == null ? "" : lp1.toLowerCase();
            String s2 = lp2 == null ? "" : lp2.toLowerCase();
            int rc = s1.compareTo(s2);
            return this.direction == 1024 ? -rc : rc;
        }

        public void setLabelProvider(ILabelProvider textProvider) {
            this.labelProvider = textProvider;
        }
    }
}

