/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.search.activation.SearchProviderActivationConfigDummy;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;
import org.mockito.Mockito;

public class SearchProviderActivationConfigDummyTest
extends TestCase {
    private static final String OBJECT_TYPE_ID = "Pesho";

    public void testGetActiveSearchProviderNoCategories() throws ProviderNotFoundException {
        IObjectTypeDescription aDescription = this.objectTypeDescriptionForId(OBJECT_TYPE_ID);
        ISearchProviderDescription expectedProvider = this.providerWithNoCategories(aDescription);
        SearchProviderActivationConfigDummy dummy = new SearchProviderActivationConfigDummy(this.createParser(this.list(this.providerWithACategory(aDescription), expectedProvider)));
        SearchProviderActivationConfigDummyTest.assertEquals((String)"Unexpected provider returned", (Object)expectedProvider, (Object)dummy.getActiveSearchProviderDescription(this.objectTypeDescriptionForId(OBJECT_TYPE_ID)));
    }

    public void testGetActiveSearchProviderNoCategoriesThrowsExpectionForProviderWithCategories() {
        IObjectTypeDescription aDescription = this.objectTypeDescriptionForId(OBJECT_TYPE_ID);
        SearchProviderActivationConfigDummy dummy = new SearchProviderActivationConfigDummy(this.createParser(this.list(this.providerWithACategory(aDescription))));
        try {
            dummy.getActiveSearchProviderDescription(this.objectTypeDescriptionForId(OBJECT_TYPE_ID));
            SearchProviderActivationConfigDummyTest.fail((String)"ProviderNotFound not thrown");
        }
        catch (ProviderNotFoundException providerNotFoundException) {}
    }

    private ISearchProvidersExtensionParser createParser(List<ISearchProviderDescription> providers) {
        ISearchProvidersExtensionParser parserMock = (ISearchProvidersExtensionParser)Mockito.mock(ISearchProvidersExtensionParser.class);
        Mockito.when((Object)parserMock.readContributions()).thenReturn(providers);
        return parserMock;
    }

    private ISearchProviderDescription providerWithCateogires(IObjectTypeDescription supportedObjectType, Set<IDestinationCategoryDescription> categories) {
        ISearchProviderDescription providerMock = (ISearchProviderDescription)Mockito.mock(ISearchProviderDescription.class);
        Mockito.when((Object)providerMock.getObjectType()).thenReturn((Object)supportedObjectType);
        Mockito.when((Object)providerMock.getSupportedDestinationCategories()).thenReturn(categories);
        return providerMock;
    }

    private ISearchProviderDescription providerWithACategory(IObjectTypeDescription supportedObjectType) {
        return this.providerWithCateogires(supportedObjectType, this.aCategory());
    }

    private Set<IDestinationCategoryDescription> aCategory() {
        HashSet<IDestinationCategoryDescription> result = new HashSet<IDestinationCategoryDescription>();
        result.add((IDestinationCategoryDescription)Mockito.mock(IDestinationCategoryDescription.class));
        return result;
    }

    private ISearchProviderDescription providerWithNoCategories(IObjectTypeDescription supportedObjectType) {
        return this.providerWithCateogires(supportedObjectType, new HashSet<IDestinationCategoryDescription>());
    }

    private IObjectTypeDescription objectTypeDescriptionForId(String id) {
        IObjectTypeDescription mock = (IObjectTypeDescription)Mockito.mock(IObjectTypeDescription.class);
        Mockito.when((Object)mock.getId()).thenReturn((Object)id);
        return mock;
    }

    private List<ISearchProviderDescription> list(ISearchProviderDescription ... descriptions) {
        return Arrays.asList(descriptions);
    }
}

