/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.internal.viewcustomization;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.IActionWithAvailability;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.IConfigurableContributedAction;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.internal.view.ISearchFavoritesItemsAdder;
import org.eclipse.platform.discovery.ui.internal.view.SearchFavoritesItemsAdder;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;

public class SaveInFavoritesMenuAction
extends Action
implements IActionWithAvailability {
    private final ISearchFavoritesItemsAdder itemsAdder;
    private final ISelection selection;

    public SaveInFavoritesMenuAction(IConfigurableContributedAction contributedAction, ISelection selection, ISearchContext searchContext, List<ISearchFavoritesViewCustomization> sbViewCustomizations, IDiscoveryEnvironment environment) {
        this.selection = selection;
        this.itemsAdder = this.createSbAdder(contributedAction, sbViewCustomizations, environment, selection, searchContext);
    }

    @Override
    public boolean isAvailable() {
        return this.itemsAdder.canAddSelection(this.selection);
    }

    public void run() {
        this.itemsAdder.addItems(this.selection);
    }

    protected ISearchFavoritesItemsAdder createSbAdder(final IConfigurableContributedAction saveAction, List<ISearchFavoritesViewCustomization> sbViewCustomizations, final IDiscoveryEnvironment environment, final ISelection selection, final ISearchContext searchCtx) {
        return new SearchFavoritesItemsAdder(sbViewCustomizations, environment.operationRunner()){

            protected void doAddItems(Set<Object> items, ILongOperationRunner operationRunner) {
                if (!$assertionsDisabled && !(selection instanceof IStructuredSelection)) {
                    throw new AssertionError();
                }
                saveAction.setErrorHandler(environment.errorHandler());
                saveAction.setSearchContext(searchCtx);
                saveAction.perform(environment.operationRunner(), SaveInFavoritesMenuAction.this.toSet((IStructuredSelection)selection));
            }
        };
    }

    private Set<Object> toSet(IStructuredSelection selection) {
        HashSet<Object> result = new HashSet<Object>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }
}

