/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class Snippet009TableViewer {
    public static void main(String[] args) {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                ViewModel viewModel = new ViewModel();
                Shell shell = new View(viewModel).createShell();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Person
    extends AbstractModelObject {
        String name = "John Smith";

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }
    }

    static class View {
        private ViewModel viewModel;
        private Table committers;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout());
            this.committers = new Table((Composite)shell, 67584);
            this.committers.setLinesVisible(true);
            TableColumn column = new TableColumn(this.committers, 0);
            TableViewer peopleViewer = new TableViewer(this.committers);
            ViewerSupport.bind((StructuredViewer)peopleViewer, (IObservableList)new WritableList(this.viewModel.getPeople(), Person.class), (IValueProperty)BeanProperties.value(Person.class, (String)"name"));
            column.pack();
            shell.setSize(100, 300);
            shell.open();
            return shell;
        }
    }

    static class ViewModel {
        private List people = new LinkedList();

        ViewModel() {
            this.people.add(new Person("Steve Northover"));
            this.people.add(new Person("Grant Gayed"));
            this.people.add(new Person("Veronika Irvine"));
            this.people.add(new Person("Mike Wilson"));
            this.people.add(new Person("Christophe Cornu"));
            this.people.add(new Person("Lynne Kues"));
            this.people.add(new Person("Silenio Quarti"));
        }

        public List getPeople() {
            return this.people;
        }
    }
}

