/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.jface.databinding.viewers.ViewerSetProperty;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckboxViewerCheckedElementsProperty<S extends Viewer>
extends ViewerSetProperty<S, Object> {
    private final Object elementType;

    public CheckboxViewerCheckedElementsProperty(Object elementType) {
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public Class<Object> getElementClass() {
        return Object.class;
    }

    protected final Set<Object> createElementSet(StructuredViewer viewer) {
        return ViewerElementSet.withComparer(viewer.getComparer());
    }

    protected void doUpdateSet(S source, SetDiff<Object> diff) {
        ICheckable checkable = (ICheckable)source;
        Iterator it = diff.getAdditions().iterator();
        while (it.hasNext()) {
            checkable.setChecked(it.next(), true);
        }
        it = diff.getRemovals().iterator();
        while (it.hasNext()) {
            checkable.setChecked(it.next(), false);
        }
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<SetDiff<Object>> listener) {
        return new CheckStateListener((IProperty)this, listener);
    }

    public String toString() {
        String s = "ICheckable.checkedElements{}";
        if (this.elementType != null) {
            s = String.valueOf(s) + " <" + this.elementType + ">";
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckStateListener
    extends NativePropertyListener<S, SetDiff<Object>>
    implements ICheckStateListener {
        private CheckStateListener(IProperty property, ISimplePropertyListener<SetDiff<Object>> listener) {
            super(property, listener);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            Set<Object> elementSet = CheckboxViewerCheckedElementsProperty.this.createElementSet((StructuredViewer)event.getCheckable());
            elementSet.add(element);
            Set<Object> additions = checked ? elementSet : Collections.emptySet();
            Set<Object> removals = checked ? Collections.emptySet() : elementSet;
            SetDiff diff = Diffs.createSetDiff(additions, removals);
            this.fireChange(event.getSource(), (IDiff)diff);
        }

        public void doAddTo(S source) {
            ((ICheckable)source).addCheckStateListener((ICheckStateListener)this);
        }

        public void doRemoveFrom(S source) {
            ((ICheckable)source).removeCheckStateListener((ICheckStateListener)this);
        }
    }
}

