/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.script.js.text;

import javax.inject.Inject;
import org.eclipse.e4.tools.emf.ui.script.js.ResourceProvider;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptSourceViewerConfiguration;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptTextTools;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JavaScriptEditor {
    private static final int VERTICAL_RULER_WIDTH = 12;
    private static PreferenceStore store = new PreferenceStore();
    private Document document = new Document();
    private SourceViewer viewer;

    static {
        store.setDefault(String.valueOf(ResourceProvider.JAVADOC_KEYWORD) + "_bold", true);
        store.setDefault(String.valueOf(ResourceProvider.JAVA_KEYWORD) + "_bold", true);
        store.setDefault(String.valueOf(ResourceProvider.JAVA_KEYWORD_RETURN) + "_bold", true);
    }

    @Inject
    public JavaScriptEditor(Composite parent, IResourcePool pool) {
        VerticalRuler verticalRuler = new VerticalRuler(12);
        int styles = 68354;
        this.viewer = new SourceViewer(parent, (IVerticalRuler)verticalRuler, styles);
        Font f = null;
        if (!JFaceResources.getFontRegistry().hasValueFor("JavaEditorFont") && (SWT.getPlatform().equals("carbon") || SWT.getPlatform().equals("cocoa"))) {
            JFaceResources.getFontRegistry().put("JavaEditorFont", new FontData[]{new FontData("Monaco", 11, 0)});
        }
        f = JFaceResources.getFontRegistry().get("JavaEditorFont");
        this.viewer.getTextWidget().setFont(f);
        JavaScriptTextTools textTools = new JavaScriptTextTools(pool, (IPreferenceStore)store);
        this.viewer.configure((SourceViewerConfiguration)new JavaScriptSourceViewerConfiguration(textTools));
        textTools.setupJavaDocumentPartitioner((IDocument)this.document, "___java_partitioning");
        this.viewer.setDocument((IDocument)this.document);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public String getContent() {
        return this.document.get();
    }
}

