/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.languages.javascript.JSBundle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Version;

public class JSExportPackage {
    private JSBundle exportingBundle;
    private String name;
    private Version version = Version.emptyVersion;
    private Map attributes = new HashMap();
    private Map directives = new HashMap();
    private List mandatory = new ArrayList();

    public JSExportPackage(String header, JSBundle exportingBundle) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (exportingBundle == null) {
            throw new IllegalArgumentException("exportingBundle cannot be null");
        }
        this.parseExport(header);
        this.exportingBundle = exportingBundle;
    }

    public JSBundle getExportingBundle() {
        return this.exportingBundle;
    }

    private void parseExport(String header) {
        StringTokenizer tokenizer = new StringTokenizer(header, ";");
        this.name = tokenizer.nextToken().trim();
        while (tokenizer.hasMoreTokens()) {
            String token = (String)tokenizer.nextElement();
            if (token.indexOf(":=") != -1) {
                this.parseDirective(token);
                continue;
            }
            if (token.indexOf("=") == -1) continue;
            this.parseAttribute(token);
        }
    }

    private void parseAttribute(String token) {
        int index = token.indexOf("=");
        String attributeName = token.substring(0, index).trim();
        if (attributeName.length() == 0) {
            return;
        }
        String value = token.substring(index + "=".length()).trim();
        if (attributeName.equals("version")) {
            this.version = Version.parseVersion((String)value);
        }
        this.attributes.put(attributeName, value);
    }

    private void parseDirective(String token) {
        int index = token.indexOf(":=");
        String directiveName = token.substring(0, index).trim();
        if (directiveName.length() == 0) {
            return;
        }
        String value = token.substring(index + ":=".length()).trim();
        if (directiveName.equals("mandatory")) {
            this.parseMandatory(value);
        }
        this.directives.put(directiveName, value);
    }

    private void parseMandatory(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = (String)tokenizer.nextElement();
            if ((token = token.trim()).length() <= 0) continue;
            this.mandatory.add(token);
        }
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getBundleSymbolicName() {
        return this.exportingBundle.getSymbolicName();
    }

    public Version getBundleVersion() {
        return this.exportingBundle.getVersion();
    }

    public int getBundleId() {
        return this.exportingBundle.getBundleId();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getDirectives() {
        return this.directives;
    }

    public List getMandatory() {
        return this.mandatory;
    }

    protected void addToScope(Scriptable scope) {
        Object value = this.exportingBundle.lookup(this.name);
        StringTokenizer tokenizer = new StringTokenizer(this.name, ".");
        while (true) {
            Scriptable wrapped;
            String token = tokenizer.nextToken();
            Object current = scope.get(token, scope);
            if (!tokenizer.hasMoreTokens()) {
                if (current == Scriptable.NOT_FOUND) {
                    if (value instanceof NativeObject) {
                        wrapped = Context.getCurrentContext().newObject(scope);
                        wrapped.setPrototype((Scriptable)value);
                        value = wrapped;
                    }
                    scope.put(token, scope, value);
                    return;
                }
                throw new IllegalStateException("Resolve error: " + this.name + " already exists for " + this.toString());
            }
            if (current == Scriptable.NOT_FOUND) {
                current = ScriptableObject.getProperty((Scriptable)scope, (String)token);
                if (current == Scriptable.NOT_FOUND) {
                    current = Context.getCurrentContext().newObject(scope);
                } else if (current instanceof NativeObject) {
                    wrapped = Context.getCurrentContext().newObject(scope);
                    wrapped.setPrototype((Scriptable)current);
                    current = wrapped;
                } else {
                    throw new IllegalStateException("Resolve error: " + this.name + "-" + token + " already exists for " + this.toString());
                }
                scope.put(token, scope, current);
            }
            scope = (Scriptable)current;
        }
    }
}

