/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.internal.languages.javascript.JSFrameworkImpl;
import org.eclipse.e4.languages.javascript.JSBundle;
import org.eclipse.e4.languages.javascript.JSBundleException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;

public class JSBundleTracker
extends BundleTracker {
    private JSFrameworkImpl framework;
    private Map jsBundleMap = new HashMap();

    public JSBundleTracker(BundleContext context, JSFrameworkImpl framework) {
        super(context, 60, null);
        this.framework = framework;
    }

    public JSBundle getJSBundle(Bundle bundle) {
        return (JSBundle)this.jsBundleMap.get(bundle);
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        String jsBundleHeader = (String)bundle.getHeaders().get("JavaScript-Bundle");
        if (jsBundleHeader == null) {
            return null;
        }
        URL jsBundleEntry = bundle.getEntry(jsBundleHeader.trim());
        if (jsBundleEntry == null) {
            return null;
        }
        try {
            JSBundle jsBundle = this.framework.installBundle(jsBundleEntry.toString(), bundle);
            this.jsBundleMap.put(bundle, jsBundle);
            this.framework.resolve();
            if (event == null && bundle.getState() == 32) {
                jsBundle.start();
            }
            return jsBundle;
        }
        catch (JSBundleException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (event == null) {
            return;
        }
        JSBundle jsBundle = (JSBundle)object;
        switch (event.getType()) {
            case 2: {
                jsBundle.start();
                break;
            }
            case 256: {
                jsBundle.stop();
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        JSBundle jsBundle = (JSBundle)object;
        jsBundle.uninstall();
        this.jsBundleMap.remove(bundle);
        this.framework.refresh();
    }
}

