/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.platform.discovery.ui.internal.view.ForkInUiProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ViewProgressMonitor
extends ForkInUiProgressMonitor
implements IProgressMonitor {
    private List<ControlEnableState> enableState;
    private final List<Control> controlsToDisable;
    private final StatusLineManager statusLineManager = new StatusLineManager();

    public ViewProgressMonitor(Composite parent, List<Control> compositesToDisableWhileWorking) {
        this.statusLineManager.createControl(parent, 0);
        this.controlsToDisable = compositesToDisableWhileWorking;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.statusLineManager.setCancelEnabled(true);
        this.enableState = new ArrayList<ControlEnableState>();
        for (Control c : this.controlsToDisable) {
            this.enableState.add(this.disableControls(c));
        }
        super.beginTask(name, totalWork);
    }

    @Override
    public void done() {
        for (ControlEnableState state : this.enableState) {
            state.restore();
        }
        super.done();
    }

    public Control getControl() {
        return this.statusLineManager.getControl();
    }

    protected ControlEnableState disableControls(Control control) {
        return ControlEnableState.disable((Control)control);
    }

    @Override
    protected IProgressMonitor delegate() {
        return this.statusLineManager.getProgressMonitor();
    }

    public void setMessage(String message) {
        this.statusLineManager.setMessage(message);
    }

    public void setMessage(String message, int severity) {
        String imageCode = null;
        switch (severity) {
            case 1: {
                imageCode = "dialog_messasge_info_image";
                break;
            }
            case 2: {
                imageCode = "dialog_messasge_warning_image";
                break;
            }
            case 4: {
                imageCode = "dialog_message_error_image";
            }
        }
        if (imageCode == null) {
            return;
        }
        this.statusLineManager.setMessage(JFaceResources.getImage((String)imageCode), message);
    }
}

