/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.platform.discovery.ui.internal.HorizontalStatePainter;
import org.eclipse.platform.discovery.ui.internal.SlidingCompositeStatePainter;
import org.eclipse.platform.discovery.ui.internal.VerticalStatePainter;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.tooltip.ControlTooltipManager;
import org.eclipse.platform.discovery.ui.internal.tooltip.IToolTipConfigurator;
import org.eclipse.platform.discovery.ui.internal.tooltip.ToolTipConfigurator;
import org.eclipse.platform.discovery.ui.internal.tooltip.TooltipCreator;
import org.eclipse.platform.discovery.ui.internal.view.ViewProgressMonitor;
import org.eclipse.platform.discovery.ui.internal.view.impl.SashOffsetCalculator;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SlidingComposite {
    private static final int HIDE_CANVAS_HEIGHT = 20;
    private static final int RESULT_HEIGHT_TO_SHOW_RESULT_TOOLTIP = 66;
    private Composite parentComposite;
    private Composite upperComposite;
    private Composite bottomComposite;
    private Sash sash;
    private Canvas hideButton;
    private final ViewProgressMonitor viewProgressMonitor;
    private FormToolkit formToolkit;
    private final Property<Boolean> upperVisible;
    private final Property<ORIENTATION> _currentOrientation;
    private final Property<Point> upperCompositeSizeProperty;
    private final ScrolledComposite scrolledUpperComposite;
    private final SlidingCompositeStatePainter _horizontalPainter;
    private final SlidingCompositeStatePainter _verticalPainter;
    private final BalloonTooltipFactory tooltipFactory = new BalloonTooltipFactory();

    public SlidingComposite(Composite parent, FormToolkit formToolkit) {
        this.formToolkit = formToolkit;
        this._horizontalPainter = new HorizontalStatePainter(this.getFormToolkit());
        this._verticalPainter = new VerticalStatePainter(this.getFormToolkit());
        this._currentOrientation = new Property();
        this._currentOrientation.set((Object)ORIENTATION.VERTICAL);
        this._currentOrientation.registerValueListener((IPropertyAttributeListener)new OrientationChangedListener(), false);
        this.parentComposite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        this.getParentComposite().setLayout((Layout)formLayout);
        this.scrolledUpperComposite = this.createScrolledComposite(this.getParentComposite(), this.formToolkit);
        this.upperComposite = formToolkit.createComposite((Composite)this.scrolledUpperComposite, 0x800000);
        this.scrolledUpperComposite.setContent((Control)this.upperComposite);
        this.configureUpperComposite(this.upperComposite);
        this.upperComposite.setLayout((Layout)new FormLayout());
        this.upperComposite.setBackground(this.getBackgroundColor());
        this.upperComposite.setForeground(this.getForegroundColor());
        this.upperComposite.setBackgroundMode(1);
        this.hideButton = new Canvas(this.getParentComposite(), 0);
        this.installHideButtonTooltip(this.hideButton);
        this.hideButton.addPaintListener((PaintListener)new HideButtonPaintListener());
        this.hideButton.addListener(4, (Listener)new HideButtonSelectionListener());
        this.sash = new Sash(this.getParentComposite(), 256);
        this.sash.addListener(13, (Listener)new SashListener());
        this.bottomComposite = formToolkit.createComposite(this.getParentComposite(), 0x800000);
        this.bottomComposite.setLayout((Layout)new FormLayout());
        this.bottomComposite.setBackground(this.getBackgroundColor());
        this.bottomComposite.setForeground(this.getForegroundColor());
        this.bottomComposite.setBackgroundMode(1);
        this.configureBottomComposite(this.bottomComposite);
        this.viewProgressMonitor = new ViewProgressMonitor(this.getParentComposite(), Arrays.asList(this.upperComposite, this.bottomComposite));
        this.adjustControlsLayoutData();
        this.getParentComposite().layout(true, true);
        this.getParentComposite().addListener(11, (Listener)new ParentCompositeResizeListener());
        this.upperVisible = new Property();
        this.upperVisible.set((Object)true);
        this.upperVisible.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<Boolean>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Boolean> event) {
                if (((Boolean)event.getNewAttribute()).booleanValue()) {
                    SlidingComposite.this.switchUpperVisibilityOn();
                } else {
                    SlidingComposite.this.switchUpperVisibilityOff();
                }
            }
        }, false);
        this.upperCompositeSizeProperty = new Property();
        this.upperCompositeSizeProperty.set((Object)this.upperComposite.computeSize(-1, -1));
        this.upperCompositeSizeProperty.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<Point>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Point> event) {
                SlidingComposite.this.moveSashToPosition(SlidingComposite.this.sashOffsetCalculator(SlidingComposite.this.getCurrentOrientation()).determineDefaultOffest());
                SlidingComposite.this.scrolledUpperComposite.setMinHeight(((Point)event.getNewAttribute()).y);
                SlidingComposite.this.scrolledUpperComposite.setMinWidth(SlidingComposite.this.getCurrentOrientation() == ORIENTATION.HORIZONTAL ? ((Point)event.getNewAttribute()).x : 0);
            }
        }, true);
    }

    private void installHideButtonTooltip(Canvas control) {
        ControlTooltipManager ttManager = new ControlTooltipManager((Control)control, new TooltipCreator()){

            @Override
            protected IToolTipConfigurator createInformation(Control control) {
                return SlidingComposite.this.hideParamsButtonTooltipConfig();
            }
        };
        ttManager.install((Control)control);
    }

    private IToolTipConfigurator hideParamsButtonTooltipConfig() {
        return new ToolTipConfigurator(){

            @Override
            protected String textContent() {
                return (Boolean)SlidingComposite.this.upperVisible.get() != false ? String.valueOf(DiscoveryUIMessages.SlidingComposite_TooltipMessage_Click_To_Hide) + "\n" + DiscoveryUIMessages.SlidingComposite_TooltipMessage_Drag_To_Resize : DiscoveryUIMessages.SlidingComposite_TooltipMessage_Click_To_Restore;
            }
        };
    }

    private ORIENTATION getCurrentOrientation() {
        return (ORIENTATION)((Object)this._currentOrientation.get());
    }

    private ScrolledComposite createScrolledComposite(Composite p, FormToolkit ft) {
        ScrolledComposite sc = new ScrolledComposite(p, 512);
        sc.setLayout((Layout)new FormLayout());
        ft.adapt((Composite)sc);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.getVerticalBar().setPageIncrement(160);
        sc.getVerticalBar().setIncrement(16);
        return sc;
    }

    private Color getForegroundColor() {
        return this.getFormToolkit().getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
    }

    private Color getBackgroundColor() {
        return this.getFormToolkit().getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
    }

    private Composite getParentComposite() {
        return this.parentComposite;
    }

    protected abstract void configureUpperComposite(Composite var1);

    protected abstract void configureBottomComposite(Composite var1);

    protected abstract void onOrientationChange(ORIENTATION var1);

    private void adjustControlsLayoutData() {
        boolean isCurrentlyVertical = this.getCurrentOrientation() == ORIENTATION.VERTICAL;
        FormData upperScrolledCompositeData = isCurrentlyVertical ? this.defaultFormDataVertical(null) : this.defaultFormDataHorizontal(null);
        FormData upperCompositeData = isCurrentlyVertical ? this.defaultFormDataVertical(null) : this.defaultFormDataHorizontal(null);
        FormData hideButtonData = isCurrentlyVertical ? this.defaultFormDataVertical((Control)this.scrolledUpperComposite) : this.defaultFormDataHorizontal((Control)this.scrolledUpperComposite);
        FormData sashData = isCurrentlyVertical ? this.defaultFormDataVertical((Control)this.hideButton) : this.defaultFormDataHorizontal((Control)this.hideButton);
        FormData bottomCompositeData = isCurrentlyVertical ? this.defaultFormDataVertical((Control)this.sash) : this.defaultFormDataHorizontal((Control)this.sash);
        this.setStatusLineControlFormData();
        this.scrolledUpperComposite.setLayoutData((Object)upperScrolledCompositeData);
        this.upperComposite.setLayoutData((Object)upperCompositeData);
        this.hideButton.setLayoutData((Object)hideButtonData);
        this.sash.setLayoutData((Object)sashData);
        bottomCompositeData.bottom = new FormAttachment(this.statusLineControl(), 0);
        this.bottomComposite.setLayoutData((Object)bottomCompositeData);
        this.painter().adjustControlsLayoutData(upperScrolledCompositeData, hideButtonData, sashData, bottomCompositeData, this.hideButton, 20);
    }

    private void setStatusLineControlFormData() {
        FormData pmFormData = new FormData();
        pmFormData.left = new FormAttachment(0, 0);
        pmFormData.right = new FormAttachment(100, 0);
        pmFormData.bottom = new FormAttachment(100, 0);
        this.statusLineControl().setLayoutData((Object)pmFormData);
    }

    private FormData defaultFormDataVertical(Control upNeighbour) {
        FormData fd = new FormData();
        fd.top = upNeighbour != null ? new FormAttachment(upNeighbour, 0) : new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        return fd;
    }

    private FormData defaultFormDataHorizontal(Control leftNeighbour) {
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = leftNeighbour != null ? new FormAttachment(leftNeighbour) : new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(this.viewProgressMonitor.getControl());
        return fd;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.viewProgressMonitor;
    }

    private Control statusLineControl() {
        return this.viewProgressMonitor.getControl();
    }

    private FormData getScrolledUpperCompositeLayoutData() {
        return (FormData)this.scrolledUpperComposite.getLayoutData();
    }

    private FormData getHideButtonLayoutData() {
        return (FormData)this.hideButton.getLayoutData();
    }

    private FormData getSashLayoutData() {
        return (FormData)this.sash.getLayoutData();
    }

    private FormData getBottomCompositeLayoutData() {
        return (FormData)this.bottomComposite.getLayoutData();
    }

    private void moveSashToPosition(int position) {
        int effectiveSashOffset = this.sashOffsetCalculator(this.getCurrentOrientation()).effectiveOffset(position);
        FormData hideButtonFormData = this.getHideButtonLayoutData();
        FormData sashFormData = this.getSashLayoutData();
        FormData upperScrolledCompositeFormData = this.getScrolledUpperCompositeLayoutData();
        FormData bottomCompositeFormData = this.getBottomCompositeLayoutData();
        this.painter().arrangeControls(hideButtonFormData, sashFormData, upperScrolledCompositeFormData, bottomCompositeFormData, effectiveSashOffset, 20);
        this.getParentComposite().layout();
        this.hideButton.redraw();
    }

    protected void switchUpperVisibilityOff() {
        assert (((Boolean)this.upperVisible.get()).booleanValue());
        this.sash.setVisible(false);
        this.moveSashToPosition(this.sashOffsetCalculator(this.getCurrentOrientation()).sashComponentHeight());
        FormData hideButtonFormData = this.getHideButtonLayoutData();
        FormData bottomCompositeFormData = this.getBottomCompositeLayoutData();
        this.painter().arrangeControlsOnUpperVisibilityOff(hideButtonFormData, bottomCompositeFormData, 20);
        this.getParentComposite().layout();
    }

    protected void switchUpperVisibilityOn() {
        assert (!((Boolean)this.upperVisible.get()).booleanValue());
        this.sash.setVisible(true);
        this.adjustControlsLayoutData();
    }

    private int getSashOffset() {
        return this.getCurrentOrientation() == ORIENTATION.VERTICAL ? this.sash.getBounds().y + this.sash.getBounds().height : this.sash.getBounds().x + this.sash.getBounds().width;
    }

    protected FormToolkit getFormToolkit() {
        return this.formToolkit;
    }

    public void upperCompositeSizeChanged(PropertyAttributeChangedEvent<Point> event) {
        this.upperCompositeSizeProperty.set((Object)((Point)event.getNewAttribute()));
    }

    public void setMessage(String message) {
        this.viewProgressMonitor.setMessage(message);
    }

    private SlidingCompositeStatePainter painter() {
        switch (this.getCurrentOrientation()) {
            case VERTICAL: {
                return this._verticalPainter;
            }
            case HORIZONTAL: {
                return this._horizontalPainter;
            }
        }
        throw new IllegalStateException("Unsupported orientation");
    }

    private IOffsetCalculator sashOffsetCalculator(ORIENTATION orientation) {
        return new SashOffsetCalculator(this.sash, this.scrolledUpperComposite, (Point)this.upperCompositeSizeProperty.get(), this.hideButton, orientation, (Boolean)this.upperVisible.get());
    }

    public void notifyBottomCompositeContentChanged(String title, String message) {
        if ((this.getCurrentOrientation() == ORIENTATION.VERTICAL ? this.bottomComposite.getSize().y : this.bottomComposite.getSize().x) < 66) {
            this.showInfoBalloon(title, message);
        }
    }

    private void showInfoBalloon(String title, String message) {
        ToolTip tt = this.tooltipFactory.newBallonTooltip((Control)this.sash, title, message);
        tt.setAutoHide(false);
        tt.setVisible(true);
    }

    private class BalloonTooltipFactory {
        private BalloonTooltipFactory() {
        }

        public ToolTip newBallonTooltip(Control parentControl, String title, String message) {
            ToolTip theTooltip = new ToolTip(parentControl.getShell(), 4098);
            HideTooltipListener hideListener = new HideTooltipListener(theTooltip);
            theTooltip.setText(title);
            theTooltip.setMessage(message);
            theTooltip.setLocation(parentControl.toDisplay((int)((double)parentControl.getSize().x * 0.66), SlidingComposite.this.getCurrentOrientation() == ORIENTATION.VERTICAL ? 0 : (int)((double)parentControl.getSize().y * 0.33)));
            SlidingComposite.this.sash.addSelectionListener((SelectionListener)hideListener);
            SlidingComposite.this.sash.addListener(11, (Listener)hideListener);
            SlidingComposite.this.hideButton.addListener(4, (Listener)hideListener);
            SlidingComposite.this.hideButton.addListener(11, (Listener)hideListener);
            SlidingComposite.this.bottomComposite.addListener(11, (Listener)hideListener);
            return theTooltip;
        }

        private class HideTooltipListener
        extends SelectionAdapter
        implements SelectionListener,
        Listener {
            private final ToolTip tooltip;

            public HideTooltipListener(ToolTip tt) {
                this.tooltip = tt;
            }

            public void widgetSelected(SelectionEvent e) {
                this.hideTooltip();
            }

            public void handleEvent(Event event) {
                this.hideTooltip();
            }

            private void hideTooltip() {
                this.tooltip.setVisible(false);
                this.tooltip.dispose();
                SlidingComposite.this.sash.removeSelectionListener((SelectionListener)this);
                SlidingComposite.this.sash.removeListener(11, (Listener)this);
                SlidingComposite.this.hideButton.removeListener(4, (Listener)this);
                SlidingComposite.this.hideButton.removeListener(11, (Listener)this);
                SlidingComposite.this.bottomComposite.removeListener(11, (Listener)this);
            }
        }
    }

    private class HideButtonPaintListener
    implements PaintListener {
        private HideButtonPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            if (SlidingComposite.this.upperComposite == null) {
                return;
            }
            Rectangle clientArea = SlidingComposite.this.hideButton.getClientArea();
            e.gc.setBackground(SlidingComposite.this.getBackgroundColor());
            e.gc.fillRectangle(clientArea);
            if (((Boolean)SlidingComposite.this.upperVisible.get()).booleanValue()) {
                SlidingComposite.this.painter().printSliderButtonUp(e, clientArea);
            } else {
                SlidingComposite.this.painter().printSliderButtonDown(e, clientArea);
            }
        }
    }

    private class HideButtonSelectionListener
    implements Listener {
        private int lastKnownSashPosition;

        private HideButtonSelectionListener() {
        }

        public void handleEvent(Event event) {
            if (((Boolean)SlidingComposite.this.upperVisible.get()).booleanValue()) {
                this.lastKnownSashPosition = SlidingComposite.this.getSashOffset();
                SlidingComposite.this.upperVisible.set((Object)false);
            } else {
                SlidingComposite.this.upperVisible.set((Object)true);
                SlidingComposite.this.moveSashToPosition(this.lastKnownSashPosition);
            }
        }
    }

    public static interface IOffsetCalculator {
        public int determineDefaultOffest();

        public int effectiveOffset(int var1);

        public int sashComponentHeight();
    }

    public static enum ORIENTATION {
        HORIZONTAL,
        VERTICAL;

    }

    private class OrientationChangedListener
    implements IPropertyAttributeListener<ORIENTATION> {
        private OrientationChangedListener() {
        }

        public void attributeChanged(PropertyAttributeChangedEvent<ORIENTATION> event) {
            this.createNewSash(event.getNewAttribute() == ORIENTATION.VERTICAL ? 256 : 512);
            SlidingComposite.this.onOrientationChange((ORIENTATION)((Object)event.getNewAttribute()));
            SlidingComposite.this.adjustControlsLayoutData();
            SlidingComposite.this.scrolledUpperComposite.layout(true, true);
            SlidingComposite.this.upperCompositeSizeProperty.set((Object)SlidingComposite.this.upperComposite.computeSize(-1, -1));
            SlidingComposite.this.moveSashToPosition(SlidingComposite.this.sashOffsetCalculator((ORIENTATION)((Object)event.getNewAttribute())).determineDefaultOffest());
        }

        private void createNewSash(int orientation) {
            if (SlidingComposite.this.sash != null) {
                SlidingComposite.this.sash.dispose();
                SlidingComposite.this.sash = new Sash(SlidingComposite.this.getParentComposite(), orientation);
                SlidingComposite.this.sash.addListener(13, (Listener)new SashListener());
            }
        }
    }

    private class ParentCompositeResizeListener
    implements Listener {
        private ParentCompositeResizeListener() {
        }

        public void handleEvent(Event event) {
            Rectangle rect = SlidingComposite.this.parentComposite.getClientArea();
            SlidingComposite.this._currentOrientation.set((Object)(rect.width >= rect.height ? ORIENTATION.HORIZONTAL : ORIENTATION.VERTICAL));
            int currentSashOffset = SlidingComposite.this.getSashOffset();
            IOffsetCalculator calc = SlidingComposite.this.sashOffsetCalculator(SlidingComposite.this.getCurrentOrientation());
            int effectiveOffset = calc.effectiveOffset(currentSashOffset);
            if (currentSashOffset != effectiveOffset) {
                SlidingComposite.this.moveSashToPosition(effectiveOffset);
            }
        }
    }

    private class SashListener
    implements Listener {
        private SashListener() {
        }

        public void handleEvent(Event event) {
            IOffsetCalculator offsetCalc = SlidingComposite.this.sashOffsetCalculator(SlidingComposite.this.getCurrentOrientation());
            SlidingComposite.this.moveSashToPosition(offsetCalc.effectiveOffset(SlidingComposite.this.getCurrentOrientation() == ORIENTATION.VERTICAL ? Math.max(event.y, offsetCalc.sashComponentHeight()) : event.x));
        }
    }
}

