/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.internal.SlidingComposite;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SashOrientation;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SWTBotSash;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotCanvas;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotUtils;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SlidingCompositePageObject
extends InShellPageObject {
    protected final String UPPER_LABEL = "UpperLabel";
    protected final String BOTTOM_LABEL = "BottomLabel";
    protected final String TEST_SHELL = "TEST SHELL";
    private final SwtBotUtils botUtils = new SwtBotUtils();
    private SlidingComposite slidingComposite;
    private boolean upperPartVisible;

    protected void createContent(Shell parent, FormToolkit formToolkit) {
        this.upperPartVisible = true;
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)new FillLayout(256));
        composite.setSize(parent.getClientArea().width, parent.getClientArea().height);
        this.slidingComposite = this.createSlidingComposite(formToolkit, composite);
    }

    private SlidingComposite createSlidingComposite(FormToolkit formToolkit, Composite parent) {
        return new SlidingComposite(parent, formToolkit){

            protected void configureBottomComposite(Composite bottomComposite) {
                this.getFormToolkit().createLabel(bottomComposite, "BottomLabel");
            }

            protected void configureUpperComposite(Composite upperComposite) {
                this.getFormToolkit().createLabel(upperComposite, "UpperLabel");
            }

            protected void switchUpperVisibilityOff() {
                super.switchUpperVisibilityOff();
                SlidingCompositePageObject.this.upperPartVisible = false;
            }

            protected void switchUpperVisibilityOn() {
                super.switchUpperVisibilityOn();
                SlidingCompositePageObject.this.upperPartVisible = true;
            }

            protected void onOrientationChange(SlidingComposite.ORIENTATION newOrientation) {
            }
        };
    }

    public SashOrientation getSashOrientation() {
        return this.getSash().getOrientation();
    }

    private SWTBotSash getSash() {
        return SWTBotSash.sash((AbstractSWTBot<? extends Composite>)this.shell(), false);
    }

    public void resize(int width, int height) {
        this.botUtils.setSize((AbstractSWTBot<? extends Control>)this.shell(), width, height);
    }

    public void moveSashBy(int offset) {
        this.getSash().move(offset);
    }

    public int getSashOffset() {
        return this.getSash().getOffset();
    }

    public void toggleHidden() {
        this.getHideButton().click();
    }

    private SwtBotCanvas getHideButton() {
        return SwtBotCanvas.canvas(this.shell().widget, true);
    }

    public HiddenState getHiddenState() {
        if (this.getSash().isVisible() && this.upperPartVisible) {
            return HiddenState.NOT_HIDDEN;
        }
        return HiddenState.HIDDEN;
    }

    public boolean isHideControlVisible() {
        return this.getHideButton().isVisible();
    }

    public void cancelCurrentOperation() {
        this.slidingComposite.getProgressMonitor().setCanceled(true);
    }

    public static enum HiddenState {
        HIDDEN,
        NOT_HIDDEN;

    }
}

