/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class ObservableDelegateTest
extends TestCase {
    private IObservableContractDelegate delegate;
    private Realm previousRealm;
    private IObservable observable;
    private String debugInfo;

    public ObservableDelegateTest(IObservableContractDelegate delegate) {
        this(null, delegate);
    }

    public ObservableDelegateTest(String testName, IObservableContractDelegate delegate) {
        super(testName);
        this.delegate = delegate;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.previousRealm = Realm.getDefault();
        this.delegate.setUp();
        this.observable = this.doCreateObservable();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delegate.tearDown();
        this.observable.dispose();
        this.observable = null;
        RealmTester.setDefault(this.previousRealm);
        this.observable = null;
        this.previousRealm = null;
    }

    protected IObservable doCreateObservable() {
        return this.delegate.createObservable(new CurrentRealm(true));
    }

    protected IObservable getObservable() {
        return this.observable;
    }

    protected IObservableContractDelegate getObservableContractDelegate() {
        return this.delegate;
    }

    protected String formatFail(String message) {
        return String.valueOf(message) + this.getDebugString();
    }

    private String getDebugString() {
        if (this.debugInfo == null) {
            this.debugInfo = "(Test: " + ((Object)((Object)this)).getClass().getName() + ", Delegate: " + this.delegate.getClass().getName() + ")";
        }
        return this.debugInfo;
    }

    protected void assertGetterCalled(Runnable runnable, String methodName, IObservable observable) {
        IObservable[] observables = ObservableTracker.runAndMonitor((Runnable)runnable, null, null);
        int count = 0;
        int i = 0;
        while (i < observables.length) {
            if (observables[i] == observable) {
                ++count;
            }
            ++i;
        }
        ObservableDelegateTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " should invoke ObservableTracker.getterCalled() once."), (int)1, (int)count);
    }
}

