/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTUtils {
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(([a-zA-Z_]+[0-9]*\\.)+[a-zA-Z_]+[a-z0-9]*)");

    public static boolean containsClassName(String name) {
        return CLASS_NAME_PATTERN.matcher(name).find();
    }

    public static void openClass(String clsName) throws ClassNotFoundException {
        Matcher matcher = CLASS_NAME_PATTERN.matcher(clsName);
        if (!matcher.find()) {
            return;
        }
        try {
            Class cls = FrameworkUtil.getBundle(JDTUtils.class).loadClass(matcher.group(1).trim());
            IProject project = JDTUtils.findProjectFor(cls);
            if (project != null) {
                JDTUtils.openInEditor(JavaCore.create((IProject)project), cls.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException("Class not found in the bundle classpath: " + clsName);
        }
    }

    private static IProject findProjectFor(Class<?> cls) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getFile(cls.getName()) != null) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private static void openInEditor(IJavaProject project, String clazz) throws ClassNotFoundException {
        if (project == null) {
            return;
        }
        try {
            IType type = project.findType(clazz);
            JavaUI.openInEditor((IJavaElement)type, (boolean)false, (boolean)true);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }
}

