/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.e4.tools.event.spy.internal.model.CapturedEventFilter;
import org.eclipse.e4.tools.event.spy.internal.model.ItemToFilter;
import org.eclipse.e4.tools.event.spy.internal.model.Operator;
import org.eclipse.e4.tools.event.spy.internal.util.CapturedEventFilterSerializer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapturedEventFilters {
    private static final String NOT_SELECTED_VALUE = "-- expected value --";
    public static final String BASE_EVENT_TOPIC = "org/eclipse/e4/ui/*";
    private final Composite control;
    private Text valueText;
    private Combo itemToFilterCombo;
    private Combo operatorCombo;
    private ToolTip validationErrorToolTip;
    private Text baseTopicText;
    private org.eclipse.swt.widgets.List filters;
    private List<CapturedEventFilter> rawFilters;
    private final Clipboard clipboard;

    public CapturedEventFilters(Composite outer) {
        this.control = new Composite(outer, 0);
        RowLayout layout = new RowLayout(512);
        layout.marginLeft = 0;
        layout.fill = true;
        this.control.setLayout((Layout)layout);
        this.rawFilters = new ArrayList<CapturedEventFilter>();
        this.clipboard = new Clipboard(this.control.getDisplay());
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CapturedEventFilters.this.clipboard != null && !CapturedEventFilters.this.clipboard.isDisposed()) {
                    CapturedEventFilters.this.clipboard.dispose();
                }
            }
        });
        this.createNewFilterGroup(this.control);
        this.createDefinedFiltersGroup(this.control);
    }

    private void createNewFilterGroup(Composite parent) {
        Group newFilterGroup = new Group(parent, 0);
        newFilterGroup.setText("New filter:");
        newFilterGroup.setLayout((Layout)new RowLayout(512));
        this.createBaseTopicSection((Composite)newFilterGroup);
        this.createAddFilterSection((Composite)newFilterGroup);
    }

    private void createBaseTopicSection(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new RowLayout(256));
        Label label = new Label(parent, 0x1000000);
        label.setText("Base topic of captured events:");
        this.baseTopicText = new Text(parent, 2048);
        this.baseTopicText.setLayoutData((Object)new RowData(312, -1));
        this.baseTopicText.setText(BASE_EVENT_TOPIC);
        this.baseTopicText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (CapturedEventFilters.this.baseTopicText.getText().trim().length() == 0) {
                    CapturedEventFilters.this.baseTopicText.setText(CapturedEventFilters.BASE_EVENT_TOPIC);
                }
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        Link link = new Link(composite, 0);
        link.setText("<a>Reset to default</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CapturedEventFilters.this.baseTopicText.setText(CapturedEventFilters.BASE_EVENT_TOPIC);
            }
        });
    }

    private void createAddFilterSection(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new RowLayout(256));
        Label label = new Label(parent, 0x1000000);
        label.setText("Capture event when:");
        this.itemToFilterCombo = new Combo(parent, 8);
        Enum[] enumArray = ItemToFilter.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemToFilter item = enumArray[n2];
            this.itemToFilterCombo.add(item.toString());
            ++n2;
        }
        this.itemToFilterCombo.select(0);
        this.operatorCombo = new Combo(parent, 8);
        enumArray = Operator.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum operator = enumArray[n2];
            this.operatorCombo.add(((Operator)operator).toString());
            ++n2;
        }
        this.operatorCombo.select(0);
        this.valueText = new Text(parent, 2048);
        this.valueText.setLayoutData((Object)new RowData(130, -1));
        this.valueText.setText(NOT_SELECTED_VALUE);
        this.valueText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (CapturedEventFilters.this.valueText.getText().trim().length() == 0) {
                    CapturedEventFilters.this.valueText.setText(CapturedEventFilters.NOT_SELECTED_VALUE);
                }
            }

            public void focusGained(FocusEvent e) {
                if (CapturedEventFilters.NOT_SELECTED_VALUE.equals(CapturedEventFilters.this.valueText.getText())) {
                    CapturedEventFilters.this.valueText.setText("");
                }
            }
        });
        Link link = new Link(parent, 0);
        link.setText("<a>Add filter</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CapturedEventFilters.this.addFilter();
            }
        });
    }

    private void createDefinedFiltersGroup(Composite parent) {
        Group definedFiltersGroup = new Group(parent, 0);
        definedFiltersGroup.setText("Defined filters (relation between filters is AND):");
        definedFiltersGroup.setLayout((Layout)new RowLayout(256));
        this.filters = new org.eclipse.swt.widgets.List((Composite)definedFiltersGroup, 2560);
        this.filters.setLayoutData((Object)new RowData(450, 84));
        this.filters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CapturedEventFilters.this.selectFilterAt(((org.eclipse.swt.widgets.List)e.widget).getSelectionIndex());
            }
        });
        this.filters.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean ctrlPressed;
                int index = ((org.eclipse.swt.widgets.List)e.widget).getSelectionIndex();
                boolean bl = ctrlPressed = (e.stateMask & 0x40000) == 262144;
                if (ctrlPressed && e.keyCode == 99) {
                    CapturedEventFilters.this.copyFilterAt(index);
                    e.doit = false;
                } else if (ctrlPressed && e.keyCode == 118) {
                    CapturedEventFilters.this.pasteFilterAt(index);
                }
            }
        });
        Composite composite = new Composite((Composite)definedFiltersGroup, 0);
        composite.setLayout((Layout)new RowLayout(512));
        Link link = new Link(composite, 0);
        link.setText("<a>Update selected</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CapturedEventFilters.this.updateFilterAt(CapturedEventFilters.this.filters.getSelectionIndex());
            }
        });
        link = new Link(composite, 0);
        link.setText("<a>Remove selected</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CapturedEventFilters.this.removeFilterAt(CapturedEventFilters.this.filters.getSelectionIndex());
            }
        });
        link = new Link(composite, 0);
        link.setText("<a>Remove all</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CapturedEventFilters.this.removeAllFilters();
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    public void setFilters(Collection<CapturedEventFilter> filters) {
        if (filters != null) {
            for (CapturedEventFilter filter : filters) {
                this.filters.add(filter.toString());
                this.rawFilters.add(filter);
            }
        }
    }

    public Collection<CapturedEventFilter> getFilters() {
        LinkedHashMap<Integer, CapturedEventFilter> result = new LinkedHashMap<Integer, CapturedEventFilter>();
        for (CapturedEventFilter filter : this.rawFilters) {
            result.put(filter.hashCode(), filter);
        }
        return result.values();
    }

    public void setBaseTopic(String baseTopic) {
        if (baseTopic != null) {
            this.baseTopicText.setText(baseTopic);
        }
    }

    public String getBaseTopic() {
        return this.baseTopicText.getText();
    }

    public boolean hasFilters() {
        return !this.rawFilters.isEmpty();
    }

    public int getFiltersCount() {
        return this.rawFilters.size();
    }

    private CapturedEventFilter createFilter() {
        ItemToFilter selectedItemToFilter = ItemToFilter.toItem(this.itemToFilterCombo.getItem(this.itemToFilterCombo.getSelectionIndex()));
        if (ItemToFilter.NotSelected.equals((Object)selectedItemToFilter)) {
            this.getTooltip().setText(String.format("%s is not selected", this.getFieldName((Object)ItemToFilter.NotSelected)));
            this.getTooltip().setVisible(true);
            return null;
        }
        Operator selectedOperator = Operator.toOperator(this.operatorCombo.getItem(this.operatorCombo.getSelectionIndex()));
        if (Operator.NotSelected.equals((Object)selectedOperator)) {
            this.getTooltip().setText(String.format("%s is not selected", this.getFieldName((Object)Operator.NotSelected)));
            this.getTooltip().setVisible(true);
            return null;
        }
        String value = this.valueText.getText();
        if (value.length() == 0 || value.equals(NOT_SELECTED_VALUE)) {
            this.getTooltip().setText(String.format("%s is empty", this.getFieldName(NOT_SELECTED_VALUE)));
            this.getTooltip().setVisible(true);
            return null;
        }
        try {
            return new CapturedEventFilter(selectedItemToFilter, selectedOperator, value);
        }
        catch (IllegalArgumentException exc) {
            this.getTooltip().setText(exc.getMessage());
            this.getTooltip().setVisible(true);
            return null;
        }
    }

    private ToolTip getTooltip() {
        if (this.validationErrorToolTip == null) {
            this.validationErrorToolTip = new ToolTip(Display.getCurrent().getActiveShell(), 4104);
        }
        return this.validationErrorToolTip;
    }

    private void addFilter() {
        this.addFilterAt(-1);
    }

    private void addFilterAt(int index) {
        CapturedEventFilter eventFilter = this.createFilter();
        if (eventFilter == null) {
            return;
        }
        String filterAsString = eventFilter.toString();
        if (index > -1 && index < this.rawFilters.size()) {
            this.filters.add(filterAsString, index);
            this.rawFilters.add(index, eventFilter);
        } else {
            this.filters.add(filterAsString);
            this.rawFilters.add(eventFilter);
        }
        this.clearFilterDefinition();
    }

    private void removeFilterAt(int index) {
        if (index < 0) {
            this.getTooltip().setText("Filter to remove is not selected");
            this.getTooltip().setVisible(true);
            return;
        }
        this.filters.remove(index);
        this.rawFilters.remove(index);
        this.clearFilterDefinition();
    }

    private void selectFilterAt(int index) {
        if (index > -1) {
            CapturedEventFilter filter = this.rawFilters.get(index);
            this.itemToFilterCombo.setText(filter.getItemToFilter().toString());
            this.operatorCombo.setText(filter.getOperator().toString());
            this.valueText.setText(filter.getValue());
        }
    }

    private void updateFilterAt(int index) {
        if (index < 0) {
            this.getTooltip().setText("Filter to update is not selected");
            this.getTooltip().setVisible(true);
            return;
        }
        CapturedEventFilter newFilter = this.createFilter();
        if (newFilter != null) {
            CapturedEventFilter filter = this.rawFilters.get(index);
            filter.setItemToFilter(newFilter.getItemToFilter());
            filter.setOperator(newFilter.getOperator());
            filter.setValue(newFilter.getValue());
            this.filters.setItem(index, newFilter.toString());
        }
    }

    private void copyFilterAt(int index) {
        this.clipboard.setContents(new Object[]{CapturedEventFilterSerializer.serialize(this.rawFilters.get(index))}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void pasteFilterAt(int index) {
        String pastedFilter = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance());
        CapturedEventFilter filter = CapturedEventFilterSerializer.deserialize(pastedFilter);
        if (filter != null && index > -1 && index < this.filters.getItemCount()) {
            this.filters.add(filter.toString(), index);
            this.rawFilters.add(index, filter);
        } else if (filter != null) {
            this.filters.add(filter.toString());
            this.rawFilters.add(filter);
        }
    }

    private void removeAllFilters() {
        if (this.rawFilters == null || this.rawFilters.isEmpty()) {
            this.getTooltip().setText("Filter list is empty");
            this.getTooltip().setVisible(true);
            return;
        }
        this.filters.removeAll();
        this.rawFilters.clear();
        this.clearFilterDefinition();
    }

    private String getFieldName(Object notSelectedName) {
        String fieldName = notSelectedName.toString().replaceAll("-", "").trim();
        return String.valueOf(Character.toUpperCase(fieldName.charAt(0))) + fieldName.substring(1);
    }

    private void clearFilterDefinition() {
        this.itemToFilterCombo.select(0);
        this.operatorCombo.select(0);
        this.valueText.setText(NOT_SELECTED_VALUE);
    }
}

