/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.demo.cheatsheets.search.internal.view;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheet;
import org.eclipse.demo.cheatsheets.search.internal.slave.RunCheatSheetAction;
import org.eclipse.demo.cheatsheets.search.internal.text.Messages;
import org.eclipse.demo.cheatsheets.search.internal.view.CheatSheetContentProvider;
import org.eclipse.demo.cheatsheets.search.internal.view.CheatSheetLabelProvider;
import org.eclipse.demo.cheatsheets.search.internal.view.ConsoleTooltipProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ITooltipProvider;

public class CheatSheetCustomization
implements IGenericViewCustomization {
    protected IMasterDiscoveryView masterView;

    public ITreeContentProvider getContentProvider() {
        return new CheatSheetContentProvider();
    }

    public ILabelProvider getLabelProvider() {
        return new CheatSheetLabelProvider();
    }

    public ITooltipProvider getTooltipProvider() {
        return new ConsoleTooltipProvider();
    }

    public void setMasterView(IMasterDiscoveryView masterView) {
        this.masterView = masterView;
    }

    public void installAction(final IContributedAction contributedAction, final IResultsViewAccessor viewAccessor) {
        if (contributedAction.getActionId().equals(RunCheatSheetAction.ACTION_ID)) {
            IStructuredSelection sel = (IStructuredSelection)viewAccessor.getTreeViewer().getSelection();
            if (!(sel.getFirstElement() instanceof ICheatSheet)) {
                return;
            }
            Action action = new Action(Messages.RunCheatSheetAction_Label){

                public void run() {
                    CheatSheetCustomization.this.doRunCheatSheet(contributedAction, viewAccessor.getTreeViewer().getSelection());
                }
            };
            viewAccessor.getMenuManager().add((IAction)action);
        }
    }

    public IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CheatSheetCustomization.this.doRunCheatSheet(new RunCheatSheetAction(), event.getSelection());
            }
        };
    }

    private void doRunCheatSheet(IContributedAction runAction, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof ICheatSheet)) {
            return;
        }
        runAction.perform(this.masterView.getEnvironment().operationRunner(), new HashSet<Object>(Arrays.asList(obj)));
    }

    public void postResultDisplayed(IResultsViewAccessor viewAccessor) {
        viewAccessor.getTreeViewer().expandToLevel(2);
    }

    public void selectionChanged(ISelection selection) {
    }
}

