/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.provisional.bind.IBidiConverter;
import org.eclipse.core.internal.databinding.provisional.bind.IModelBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITargetBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITwoWayBinding;
import org.eclipse.core.internal.databinding.provisional.bind.TwoWayConversionBinding;
import org.eclipse.core.internal.databinding.provisional.bind.TwoWayValidationBinding;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TwoWayBinding<T2>
implements ITwoWayBinding<T2>,
IModelBinding<T2> {
    protected boolean pullInitialValue;
    protected ITargetBinding<T2> targetBinding;

    public TwoWayBinding(boolean pullInitialValue) {
        this.pullInitialValue = pullInitialValue;
    }

    @Override
    public <T3> ITwoWayBinding<T3> convert(IBidiConverter<T2, T3> converter) {
        if (this.targetBinding != null) {
            throw new RuntimeException("When chaining together a binding, you cannot chain more than one target.");
        }
        TwoWayConversionBinding<T3, T2> nextBinding = new TwoWayConversionBinding<T3, T2>(this, converter, this.pullInitialValue);
        this.targetBinding = nextBinding;
        return nextBinding;
    }

    @Override
    public <T3> ITwoWayBinding<T3> convertWithTracking(IBidiConverter<T2, T3> converter) {
        if (this.targetBinding != null) {
            throw new RuntimeException("When chaining together a binding, you cannot chain more than one target.");
        }
        TwoWayConversionBinding<T3, T2> nextBinding = new TwoWayConversionBinding<T3, T2>(this, converter, this.pullInitialValue);
        this.targetBinding = nextBinding;
        return nextBinding;
    }

    public ITwoWayBinding<T2> validate(IValidator<T2> validator) {
        if (this.targetBinding != null) {
            throw new RuntimeException("When chaining together a binding, you cannot chain more than one target.");
        }
        TwoWayValidationBinding<T2> nextBinding = new TwoWayValidationBinding<T2>(this, validator, this.pullInitialValue);
        this.targetBinding = nextBinding;
        return nextBinding;
    }

    @Override
    public void to(IObservableValue<T2> targetObservable) {
        this.to(targetObservable, null);
    }

    @Override
    public <S> void to(IValueProperty<S, T2> targetProperty, S source) {
        IObservableValue targetObservable = targetProperty.observe(source);
        this.to((IObservableValue<T2>)targetObservable);
    }

    public void to(final IObservableValue<T2> targetObservable, final IObservableValue<IStatus> statusObservable) {
        if (this.pullInitialValue) {
            targetObservable.setValue(this.getModelValue());
        }
        final boolean[] isChanging = new boolean[1];
        this.targetBinding = new ITargetBinding<T2>(){

            @Override
            public void setTargetValue(T2 targetValue) {
                try {
                    isChanging[0] = true;
                    targetObservable.setValue(targetValue);
                }
                finally {
                    isChanging[0] = false;
                }
            }

            @Override
            public void setStatus(IStatus status) {
                if (statusObservable != null) {
                    statusObservable.setValue((Object)status);
                }
            }
        };
        targetObservable.addValueChangeListener(new IValueChangeListener<T2>(){

            public void handleValueChange(ValueChangeEvent<T2> event) {
                if (!isChanging[0]) {
                    TwoWayBinding.this.setModelValue(event.diff.getNewValue());
                }
            }
        });
        targetObservable.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                TwoWayBinding.this.removeModelListener();
            }
        });
    }
}

