/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.provisional.bind.DefaultValueBinding;
import org.eclipse.core.internal.databinding.provisional.bind.IOneWayBinding;
import org.eclipse.core.internal.databinding.provisional.bind.IOneWayModelBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITargetBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITwoWayBinding;
import org.eclipse.core.internal.databinding.provisional.bind.OneWayConversionBinding;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OneWayBinding<T2>
implements IOneWayBinding<T2>,
IOneWayModelBinding<T2> {
    protected ITargetBinding<T2> targetBinding;

    @Override
    public <T3> IOneWayBinding<T3> convert(IConverter<T2, T3> converter) {
        if (this.targetBinding != null) {
            throw new RuntimeException("When chaining together a binding, you cannot chain more than one target.");
        }
        OneWayConversionBinding<T3, T2> nextBinding = new OneWayConversionBinding<T3, T2>(this, converter);
        this.targetBinding = nextBinding;
        return nextBinding;
    }

    @Override
    public <T3> IOneWayBinding<T3> convertWithTracking(IConverter<T2, T3> converter) {
        if (this.targetBinding != null) {
            throw new RuntimeException("When chaining together a binding, you cannot chain more than one target.");
        }
        OneWayConversionBinding<T3, T2> nextBinding = new OneWayConversionBinding<T3, T2>(this, converter);
        this.targetBinding = nextBinding;
        return nextBinding;
    }

    @Override
    public ITwoWayBinding<T2> untilTargetChanges() {
        if (this.targetBinding != null) {
            throw new RuntimeException("When chaining together a binding, you cannot chain more than one target.");
        }
        DefaultValueBinding<T2> nextBinding = new DefaultValueBinding<T2>(this);
        this.targetBinding = nextBinding;
        return nextBinding;
    }

    @Override
    public void to(final IObservableValue<T2> targetObservable) {
        targetObservable.setValue(this.getModelValue());
        this.targetBinding = new ITargetBinding<T2>(){

            @Override
            public void setTargetValue(T2 targetValue) {
                targetObservable.setValue(targetValue);
            }

            @Override
            public void setStatus(IStatus status) {
            }
        };
        targetObservable.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                OneWayBinding.this.removeModelListener();
            }
        });
    }

    @Override
    public <S> void to(IValueProperty<S, T2> targetProperty, S source) {
        IObservableValue targetObservable = targetProperty.observe(source);
        this.to((IObservableValue<T2>)targetObservable);
    }

    public void setStatus(IStatus status) {
        this.targetBinding.setStatus(status);
    }
}

