/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.PatternFilter;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MenuIdDialog
extends TitleAreaDialog {
    private EModelService modelService;
    private TableViewer viewer;
    private EditingDomain domain;
    private IModelResource resource;
    private MMenuContribution menuContribution;
    private Messages messages;

    public MenuIdDialog(Shell parentShell, IModelResource resource, MMenuContribution menuContribution, EditingDomain domain, EModelService modelService, Messages Messages2) {
        super(parentShell);
        this.resource = resource;
        this.modelService = modelService;
        this.messages = Messages2;
        this.domain = domain;
        this.menuContribution = menuContribution;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.messages.MenuIdDialog_ShellTitle);
        this.setTitle(this.messages.MenuIdDialog_DialogTitle);
        this.setMessage(this.messages.MenuIdDialog_DialogMessage);
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.messages.MenuIdDialog_Id);
        Text idField = new Text(container, 2688);
        idField.setLayoutData((Object)new GridData(768));
        PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        l = new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MenuIdDialog.this.okPressed();
            }
        });
        ControlFactory.attachFiltering(idField, this.viewer, filter);
        if (this.resource.getRoot().get(0) instanceof MApplication) {
            ArrayList<MMenu> list = new ArrayList<MMenu>();
            MApplication ma = (MApplication)this.resource.getRoot().get(0);
            for (MWindow m : ma.getChildren()) {
                list.add(m.getMainMenu());
            }
            List mp = this.modelService.findElements((MUIElement)ma, null, MPart.class, null);
            for (MPart mPart : mp) {
                list.addAll(mPart.getMenus());
            }
            List mt = this.modelService.findElements((MUIElement)ma, null, MToolItem.class, null);
            for (MToolItem mToolItem : mt) {
                if (mToolItem.getMenu() == null) continue;
                list.add(mToolItem.getMenu());
            }
            MMenu[] mMenuArray = list.toArray(new MMenu[0]);
            int n = mMenuArray.length;
            int n2 = 0;
            while (n2 < n) {
                MMenu mMenuEntry = mMenuArray[n2];
                this.performRecursiveCheck(mMenuEntry, list);
                ++n2;
            }
            this.viewer.setInput(list);
        } else if (this.resource.getRoot().get(0) instanceof MModelFragments) {
            ArrayList<MApplicationElement> list = new ArrayList<MApplicationElement>();
            for (MApplicationElement f : ((MModelFragments)this.resource.getRoot().get(0)).getImports()) {
                if (!(f instanceof MMenu)) continue;
                list.add(f);
            }
            this.viewer.setInput(list);
        }
        return comp;
    }

    private void performRecursiveCheck(MMenu mMenu, List<MMenu> list) {
        List children = mMenu.getChildren();
        for (MMenuElement child : children) {
            if (!(child instanceof MMenu)) continue;
            MMenu mMenuChild = (MMenu)child;
            list.add(mMenuChild);
            this.performRecursiveCheck(mMenuChild, list);
        }
    }

    protected void okPressed() {
        MMenu el;
        Command cmd;
        if (!this.viewer.getSelection().isEmpty() && (cmd = SetCommand.create((EditingDomain)this.domain, (Object)this.menuContribution, (Object)MenuPackageImpl.Literals.MENU_CONTRIBUTION__PARENT_ID, (Object)(el = (MMenu)((IStructuredSelection)this.viewer.getSelection()).getFirstElement()).getElementId())).canExecute()) {
            this.domain.getCommandStack().execute(cmd);
            super.okPressed();
        }
    }

    static class LabelProviderImpl
    extends StyledCellLabelProvider {
        LabelProviderImpl() {
        }

        public void update(ViewerCell cell) {
            MMenu el = (MMenu)cell.getElement();
            String elementId = el.getElementId() != null ? el.getElementId() : "(Id missing)";
            StyledString str = new StyledString(elementId);
            str.append(" - " + el.getLabel(), StyledString.DECORATIONS_STYLER);
            cell.setText(str.getString());
            cell.setStyleRanges(str.getStyleRanges());
        }
    }
}

