/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy.internal.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;

public class ToggleLink {
    private Link link;
    private ClickListener listener;
    private String[] text = new String[]{"", ""};

    public ToggleLink(Composite parent) {
        this.link = new Link(parent, 0);
        this.link.setSize(-1, -1);
        this.link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ToggleLink.this.updateText();
                if (ToggleLink.this.listener != null) {
                    ToggleLink.this.listener.clicked(ToggleLink.this.isToggled());
                }
            }
        });
    }

    private void updateText() {
        String textToUpdate = this.link.getText().contains(this.text[0]) ? this.text[1] : this.text[0];
        this.setText(textToUpdate);
    }

    private void setText(String text) {
        this.link.setText(String.format("<a>%s</a>", text));
    }

    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    public void setText(String[] text) {
        this.text = text;
        this.setText(this.isToggled() ? text[1] : text[0]);
    }

    public Control getControl() {
        return this.link;
    }

    private boolean isToggled() {
        return this.link.getText().contains(this.text[1]);
    }

    public static interface ClickListener {
        public void clicked(boolean var1);
    }
}

