/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.platform.discovery.util.internal.property.ListChangeListenerMaintainer;
import org.eclipse.platform.discovery.util.internal.property.PropertyListChangedEvent;

public class NotifyingList<T>
implements List<T> {
    private final ListChangeListenerMaintainer<T> eventing;
    private final List<T> delegate;

    @Override
    public <E> E[] toArray(E[] a) {
        return this.delegate().toArray(a);
    }

    public NotifyingList(List<T> delegate, ListChangeListenerMaintainer<T> eventing) {
        this.delegate = delegate;
        this.eventing = eventing;
    }

    private List<T> delegate() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public void add(int index, T element) {
        this.delegate().add(index, element);
        this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, element);
    }

    @Override
    public boolean add(T o) {
        boolean res = this.delegate().add(o);
        this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, o);
        return res;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean res = this.delegate().addAll(c);
        this.eventing.fireEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, c);
        return res;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean res = this.delegate().addAll(index, c);
        this.eventing.fireEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, c);
        return res;
    }

    @Override
    public void clear() {
        ArrayList<T> cleared = new ArrayList<T>(this.delegate());
        this.delegate().clear();
        this.eventing.fireEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, cleared);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate().containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.delegate().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate().lastIndexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NotifyingListIterator(this.delegate().listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new NotifyingListIterator(this.delegate().listIterator(index));
    }

    @Override
    public T remove(int index) {
        T res = this.delegate().remove(index);
        this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.delegate().get(index));
        return res;
    }

    @Override
    public boolean remove(Object o) {
        boolean res = false;
        if (this.delegate().contains(o)) {
            Object toRemove = o;
            res = this.delegate().remove(o);
            this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, toRemove);
        }
        return res;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ArrayList<T> copy = new ArrayList<T>(this.delegate());
        copy.retainAll(c);
        boolean res = this.delegate.removeAll(c);
        this.eventing.fireEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, copy);
        return res;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<T> copy = new ArrayList<T>(this.delegate());
        copy.removeAll(c);
        boolean res = this.delegate().retainAll(c);
        this.eventing.fireEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, copy);
        return res;
    }

    @Override
    public T set(int index, T element) {
        T res = this.delegate().set(index, element);
        this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, res);
        this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, element);
        return res;
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    class NotifyingListIterator
    implements ListIterator<T> {
        private final ListIterator<T> delegate;
        private T currentElement;

        public NotifyingListIterator(ListIterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void add(T o) {
            this.delegate.add(o);
            NotifyingList.this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, o);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public T next() {
            this.currentElement = this.delegate.next();
            return this.currentElement;
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public T previous() {
            this.currentElement = this.delegate.previous();
            return this.currentElement;
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
            NotifyingList.this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, this.currentElement);
        }

        @Override
        public void set(T o) {
            Object prevCurrent = this.currentElement;
            this.delegate.set(o);
            this.currentElement = o;
            NotifyingList.this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_REMOVED, prevCurrent);
            NotifyingList.this.eventing.fireSingleEvent(PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, o);
        }
    }
}

