/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SashOrientation;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.SlidingCompositePageObject;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlidingCompositeTest {
    private SlidingCompositePageObject slidingComposite;

    @Before
    public void setUp() {
        this.slidingComposite = new SlidingCompositePageObject();
        this.slidingComposite.open();
        this.makeCompositeHigh();
    }

    private void makeCompositeHigh() {
        this.slidingComposite.resize(200, 300);
    }

    private void makeCompositeWide() {
        this.slidingComposite.resize(500, 100);
    }

    @After
    public void tearDown() {
        this.slidingComposite.close();
    }

    @Test
    public void testResizeCauseReorientationIfWidthIsGreaterThanHeight() {
        Assert.assertEquals((String)"Sash is not horizontal", (Object)((Object)SashOrientation.HORIZONTAL), (Object)((Object)this.slidingComposite.getSashOrientation()));
        this.makeCompositeWide();
        Assert.assertEquals((String)"Sash is not vertical", (Object)((Object)SashOrientation.VERTICAL), (Object)((Object)this.slidingComposite.getSashOrientation()));
    }

    @Test
    public void testMovingSashResizesBothParts() {
        this.slidingComposite.moveSashBy(-15);
        int initialOffset = this.slidingComposite.getSashOffset();
        this.slidingComposite.moveSashBy(15);
        int newOffset = this.slidingComposite.getSashOffset();
        int delta = newOffset - initialOffset;
        Assert.assertTrue((String)"new offset should be bigger than initial offset because sash was dragged downwards", (delta > 0 ? 1 : 0) != 0);
        int deviation = 15 - delta;
        Assert.assertTrue((String)("Unacceptable bottom composite size; Deviation: " + deviation), (Math.abs(deviation) <= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testHidingUpperPart() {
        Assert.assertEquals((String)"Unexpected hidden state", (Object)((Object)SlidingCompositePageObject.HiddenState.NOT_HIDDEN), (Object)((Object)this.slidingComposite.getHiddenState()));
        this.slidingComposite.toggleHidden();
        Assert.assertEquals((String)"Unexpected hidden state", (Object)((Object)SlidingCompositePageObject.HiddenState.HIDDEN), (Object)((Object)this.slidingComposite.getHiddenState()));
    }

    @Test
    public void testShowingUpperPart() {
        Assert.assertEquals((String)"Unexpected hidden state", (Object)((Object)SlidingCompositePageObject.HiddenState.NOT_HIDDEN), (Object)((Object)this.slidingComposite.getHiddenState()));
        this.slidingComposite.toggleHidden();
        this.slidingComposite.toggleHidden();
        Assert.assertEquals((String)"Unexpected hidden state", (Object)((Object)SlidingCompositePageObject.HiddenState.NOT_HIDDEN), (Object)((Object)this.slidingComposite.getHiddenState()));
    }

    @Test
    public void testShowUpperPartPreservesSashPosition() {
        this.slidingComposite.moveSashBy(100);
        int initialOffset = this.slidingComposite.getSashOffset();
        this.slidingComposite.toggleHidden();
        this.slidingComposite.toggleHidden();
        int newOffset = this.slidingComposite.getSashOffset();
        Assert.assertEquals((String)"Sash not put in the original location", (long)initialOffset, (long)newOffset);
    }

    @Test
    public void testSashCannotBeMovedLowerThanUpperComposite() {
        int initialSashOffset = this.slidingComposite.getSashOffset();
        this.slidingComposite.moveSashBy(-13);
        Assert.assertFalse((initialSashOffset == this.slidingComposite.getSashOffset() ? 1 : 0) != 0);
        this.slidingComposite.moveSashBy(20);
        Assert.assertEquals((String)"The sash location does not equal to initial location", (long)initialSashOffset, (long)this.slidingComposite.getSashOffset());
    }

    @Test
    public void testMovingSlashTooUpDoesNotHideButton() {
        this.slidingComposite.moveSashBy(-10000);
        Assert.assertTrue((String)"Hide button went out of shell", (boolean)this.slidingComposite.isHideControlVisible());
    }

    @Test
    public void testResizingShellDoesNotHideButton() {
        this.slidingComposite.resize(40, 600);
        this.slidingComposite.moveSashBy(600);
        this.slidingComposite.resize(40, 50);
        int sashOffset = this.slidingComposite.getSashOffset();
        int distanceFromCompositeBottom = 50 - sashOffset;
        Assert.assertTrue((String)("Hide button is not at the bottom of the shell; delta = " + distanceFromCompositeBottom), (distanceFromCompositeBottom < 30 && distanceFromCompositeBottom > 20 ? 1 : 0) != 0);
    }

    @Test
    public void testMovingSashOverProgressMonitor() {
        this.slidingComposite.resize(40, 50);
        int initialOffset = this.slidingComposite.getSashOffset();
        this.slidingComposite.moveSashBy(10);
        Assert.assertEquals((String)"Sash unexpectedly moved probably over the progress monitor", (long)initialOffset, (long)this.slidingComposite.getSashOffset());
    }

    @Test
    public void testProgressMonitorCanBeCancelledOutOfUiThread() {
        Assert.assertNull((String)"Test should be executed out of UI thread", (Object)Display.getCurrent());
        this.slidingComposite.cancelCurrentOperation();
    }
}

