/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.SelectionProviderProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.internal.databinding.viewers.ViewerMultipleSelectionProperty;
import org.eclipse.jface.internal.databinding.viewers.ViewerObservableValueDecorator;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewersObservables {
    private static void checkNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public static <S extends Viewer> IViewerObservableValue<S> observeDelayedValue(int delay, IViewerObservableValue<S> observable) {
        return new ViewerObservableValueDecorator<Viewer>((IObservableValue<Object>)Observables.observeDelayedValue((int)delay, observable), observable.getViewer());
    }

    public static IObservableValue<Object> observeSingleSelection(ISelectionProvider selectionProvider) {
        ViewersObservables.checkNull(selectionProvider);
        return SelectionProviderProperties.singleSelection().observe((Object)selectionProvider);
    }

    public static IObservableValue<Object> observeSinglePostSelection(IPostSelectionProvider selectionProvider) {
        ViewersObservables.checkNull(selectionProvider);
        return SelectionProviderProperties.singlePostSelection().observe((Object)selectionProvider);
    }

    public static IObservableList<Object> observeMultiSelection(ISelectionProvider selectionProvider) {
        ViewersObservables.checkNull(selectionProvider);
        return SelectionProviderProperties.multipleSelection().observe((Object)selectionProvider);
    }

    public static IObservableList<Object> observeMultiPostSelection(IPostSelectionProvider selectionProvider) {
        ViewersObservables.checkNull(selectionProvider);
        return SelectionProviderProperties.multiplePostSelection().observe((Object)selectionProvider);
    }

    public static IViewerObservableValue<Viewer> observeSingleSelection(Viewer viewer) {
        ViewersObservables.checkNull(viewer);
        return ViewerProperties.singleSelection().observe(viewer);
    }

    public static IViewerObservableValue<Viewer> observeSinglePostSelection(StructuredViewer viewer) {
        ViewersObservables.checkNull(viewer);
        return ViewerProperties.singlePostSelection().observe((Viewer)viewer);
    }

    public static <S extends Viewer> IViewerObservableList<S> observeMultiSelection(S viewer) {
        ViewersObservables.checkNull(viewer);
        return new ViewerMultipleSelectionProperty<S>(false).observe(viewer);
    }

    public static <S extends StructuredViewer> IViewerObservableList<S> observeMultiPostSelection(S viewer) {
        ViewersObservables.checkNull(viewer);
        return new ViewerMultipleSelectionProperty<S>(true).observe(viewer);
    }

    public static IObservableValue<Object> observeInput(Viewer viewer) {
        ViewersObservables.checkNull(viewer);
        return ViewerProperties.input().observe(viewer);
    }

    public static IObservableSet<Object> observeCheckedElements(ICheckable checkable, Object elementType) {
        ViewersObservables.checkNull(checkable);
        return ViewerProperties.checkedElements(elementType).observe(checkable);
    }

    public static IViewerObservableSet<CheckboxTableViewer, Object> observeCheckedElements(CheckboxTableViewer viewer, Object elementType) {
        ViewersObservables.checkNull(viewer);
        return ViewerProperties.checkboxTableElements(elementType).observe(viewer);
    }

    public static IViewerObservableSet<CheckboxTreeViewer, Object> observeCheckedElements(CheckboxTreeViewer viewer, Object elementType) {
        ViewersObservables.checkNull(viewer);
        return ViewerProperties.checkboxTreeElements(elementType).observe(viewer);
    }

    public static IViewerObservableSet<StructuredViewer, ViewerFilter> observeFilters(StructuredViewer viewer) {
        ViewersObservables.checkNull(viewer);
        return ViewerProperties.filters().observe(viewer);
    }
}

