/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableMapCellLabelProvider
extends CellLabelProvider {
    protected IObservableMap<Object, Object>[] attributeMaps;
    private IMapChangeListener<Object, Object> mapChangeListener = new IMapChangeListener<Object, Object>(){

        public void handleMapChange(MapChangeEvent<Object, Object> event) {
            Set affectedElements = event.diff.getChangedKeys();
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)ObservableMapCellLabelProvider.this, affectedElements.toArray());
            ObservableMapCellLabelProvider.this.fireLabelProviderChanged(newEvent);
        }
    };

    public ObservableMapCellLabelProvider(IObservableMap<Object, Object> attributeMap) {
        this(new IObservableMap[]{attributeMap});
    }

    protected ObservableMapCellLabelProvider(IObservableMap<Object, Object>[] attributeMaps) {
        this.attributeMaps = new IObservableMap[attributeMaps.length];
        System.arraycopy(attributeMaps, 0, this.attributeMaps, 0, attributeMaps.length);
        int i = 0;
        while (i < attributeMaps.length) {
            attributeMaps[i].addMapChangeListener(this.mapChangeListener);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.attributeMaps.length) {
            this.attributeMaps[i].removeMapChangeListener(this.mapChangeListener);
            ++i;
        }
        super.dispose();
        this.attributeMaps = null;
        this.mapChangeListener = null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        Object value = this.attributeMaps[0].get(element);
        cell.setText(value == null ? "" : value.toString());
    }
}

