/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationCategoryExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationsProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.DestinationsProviderExtensionParser;
import org.osgi.framework.Bundle;

public class DestinationsCategoryExtensionParser
extends AbstractExtensionPointParser<IDestinationCategoryDescription>
implements IDestinationCategoryExtensionParser {
    public static final String XP_ID = "org.eclipse.platform.discovery.runtime.destinationcategory";
    public static final String XP_ELEMENT_NAME = "destinationcategory";
    public static final String CATEGORY_ID_ATTRIBUTE = "id";
    public static final String CATEGORY_DISPLAY_NAME_ATTRIBUTE = "displayname";
    public static final String DESTINATIONS_CLASS_ATTRIBUTE = "destinationclass";
    private final IDestinationsProviderExtensionParser destinationsProviderExtParser;

    public DestinationsCategoryExtensionParser() {
        this(Platform.getExtensionRegistry());
    }

    public DestinationsCategoryExtensionParser(IExtensionRegistry registry) {
        super(registry, XP_ID, XP_ELEMENT_NAME);
        this.destinationsProviderExtParser = new DestinationsProviderExtensionParser(registry);
    }

    @Override
    protected IDestinationCategoryDescription createObject(final IConfigurationElement element) {
        return new IDestinationCategoryDescription(){

            @Override
            public List<String> getDestinationProviderIds() {
                return DestinationsCategoryExtensionParser.this.getDestProviderIds(this.getId());
            }

            @Override
            public String getDisplayName() {
                return element.getAttribute(DestinationsCategoryExtensionParser.CATEGORY_DISPLAY_NAME_ATTRIBUTE);
            }

            @Override
            public String getId() {
                return element.getAttribute(DestinationsCategoryExtensionParser.CATEGORY_ID_ATTRIBUTE);
            }

            @Override
            public Class<ISearchDestination> getDestinationsClass() {
                return DestinationsCategoryExtensionParser.this.classForDestinationName(element);
            }
        };
    }

    private List<String> getDestProviderIds(String categoryId) {
        ArrayList<String> result = new ArrayList<String>();
        for (IDestinationsProviderDescription provider : this.destinationsProviderExtParser.readContributions()) {
            if (!provider.getDestinationCategoryId().equals(categoryId)) continue;
            result.add(provider.getId());
        }
        return result;
    }

    private Class<ISearchDestination> classForDestinationName(IConfigurationElement configElement) {
        Bundle bundle = Platform.getBundle((String)configElement.getNamespaceIdentifier());
        try {
            return bundle.loadClass(configElement.getAttribute(DESTINATIONS_CLASS_ATTRIBUTE));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

