/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.ITooltipProvider;
import org.eclipse.platform.discovery.ui.api.impl.GenericViewCustomizationImpl;
import org.eclipse.platform.discovery.ui.internal.tooltip.FormTextBuilder;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.GenericResultLabelProvider;
import org.eclipse.platform.discovery.ui.test.unit.internal.GenericResultContentProviderTest;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jmock.core.Constraint;

public class GenericResultLabelProviderTest
extends MockObjectTestCase {
    private static final String TEXT_1 = "Text1";
    private static final String TEXT_2 = "Text2";
    private Image image1;
    private Image image2;
    private Mock<ILabelProvider> labelProvider1;
    private Mock<ILabelProvider> labelProvider2;
    private Mock<ITooltipProvider> tooltipProvider1;
    private Mock<ITooltipProvider> tooltipProvider2;
    private Object element1;
    private Object element2;
    private Object element3;
    private Set<IGenericViewCustomization> customizations;
    private GenericResultLabelProvider testedProvider;

    protected void setUp() throws Exception {
        this.element1 = new Object();
        this.element2 = new Object();
        this.element3 = new Object();
        this.setupImages();
        this.setupLabelProviders();
        this.setupTooltipProviders();
        this.setupCustomizations();
        this.testedProvider = new GenericResultLabelProvider(new ArrayList<IGenericViewCustomization>(this.customizations));
    }

    private void setupImages() {
        this.image1 = new Image((Device)PlatformUI.getWorkbench().getDisplay(), GenericResultContentProviderTest.class.getResourceAsStream("resources/img1.gif"));
        GenericResultLabelProviderTest.assertNotNull((Object)this.image1);
        this.image2 = new Image((Device)PlatformUI.getWorkbench().getDisplay(), GenericResultContentProviderTest.class.getResourceAsStream("resources/img2.gif"));
        GenericResultLabelProviderTest.assertNotNull((Object)this.image2);
    }

    private void setupCustomizations() {
        this.customizations = new HashSet<IGenericViewCustomization>();
        this.customizations.add((IGenericViewCustomization)this.viewCustomization((ILabelProvider)this.labelProvider1.proxy(), (ITooltipProvider)this.tooltipProvider1.proxy()));
        this.customizations.add((IGenericViewCustomization)this.viewCustomization((ILabelProvider)this.labelProvider2.proxy(), (ITooltipProvider)this.tooltipProvider2.proxy()));
        this.customizations.add((IGenericViewCustomization)this.viewCustomization(null, null));
    }

    private ISearchConsoleCustomization viewCustomization(final ILabelProvider lProvider, final ITooltipProvider tooltipProvider) {
        return new TestCustomization(){

            public boolean acceptSearchProvider(String searchProviderId) {
                throw new UnsupportedOperationException();
            }

            public ITreeContentProvider getContentProvider() {
                throw new UnsupportedOperationException();
            }

            public ILabelProvider getLabelProvider() {
                return lProvider;
            }

            public ITooltipProvider getTooltipProvider() {
                return tooltipProvider;
            }

            public void installAction(IContributedAction contributedAction, IResultsViewAccessor viewAccessor) {
                throw new UnsupportedOperationException();
            }

            public void setMasterView(IMasterDiscoveryView masterView) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void setupTooltipProviders() {
        this.tooltipProvider1 = this.mock(ITooltipProvider.class);
        this.tooltipProvider2 = this.mock(ITooltipProvider.class);
    }

    private void setupLabelProviders() {
        this.labelProvider1 = this.mock(ILabelProvider.class);
        this.labelProvider1.stubs().method("getImage").with((Constraint)this.eq(this.element1)).will(this.returnValue(this.image1));
        this.labelProvider1.stubs().method("getImage").with((Constraint)this.eq(this.element2)).will(this.returnValue(null));
        this.labelProvider1.stubs().method("getImage").with((Constraint)this.eq(this.element3)).will(this.returnValue(null));
        this.labelProvider1.stubs().method("getText").with((Constraint)this.eq(this.element1)).will(this.returnValue(TEXT_1));
        this.labelProvider1.stubs().method("getText").with((Constraint)this.eq(this.element2)).will(this.returnValue(null));
        this.labelProvider1.stubs().method("getText").with((Constraint)this.eq(this.element3)).will(this.returnValue(null));
        this.labelProvider2 = this.mock(ILabelProvider.class);
        this.labelProvider2.stubs().method("getImage").with((Constraint)this.eq(this.element1)).will(this.returnValue(null));
        this.labelProvider2.stubs().method("getImage").with((Constraint)this.eq(this.element2)).will(this.returnValue(this.image2));
        this.labelProvider2.stubs().method("getImage").with((Constraint)this.eq(this.element3)).will(this.returnValue(null));
        this.labelProvider2.stubs().method("getText").with((Constraint)this.eq(this.element1)).will(this.returnValue(null));
        this.labelProvider2.stubs().method("getText").with((Constraint)this.eq(this.element2)).will(this.returnValue(TEXT_2));
        this.labelProvider2.stubs().method("getText").with((Constraint)this.eq(this.element3)).will(this.returnValue(null));
    }

    public void testGetText() {
        GenericResultLabelProviderTest.assertEquals((String)"Unexpected text", (String)TEXT_1, (String)this.testedProvider.getText(this.element1));
        GenericResultLabelProviderTest.assertEquals((String)"Unexpected text", (String)TEXT_2, (String)this.testedProvider.getText(this.element2));
        GenericResultLabelProviderTest.assertNull((String)"Unexpected text", (Object)this.testedProvider.getText(this.element3));
    }

    public void testGetToolTipTextForUI() {
        this.tooltipProvider1.expects(this.once()).method("createTooltipContent").with((Constraint)this.isA(FormTextBuilder.class), (Constraint)this.eq(this.element1));
        this.tooltipProvider2.expects(this.once()).method("createTooltipContent").with((Constraint)this.isA(FormTextBuilder.class), (Constraint)this.eq(this.element1));
        this.testedProvider.getToolTipText(this.element1);
    }

    public void testGetImage() {
        GenericResultLabelProviderTest.assertTrue((String)"Unexpected image", (this.image1 == this.testedProvider.getImage(this.element1) ? 1 : 0) != 0);
        GenericResultLabelProviderTest.assertTrue((String)"Unexpected image", (this.image2 == this.testedProvider.getImage(this.element2) ? 1 : 0) != 0);
        GenericResultLabelProviderTest.assertNull((String)"Unexpected image", (Object)this.testedProvider.getImage(this.element3));
    }

    protected void tearDown() throws Exception {
        this.image1.dispose();
        this.image2.dispose();
    }

    private abstract class TestCustomization
    extends GenericViewCustomizationImpl
    implements ISearchConsoleCustomization {
        private TestCustomization() {
        }
    }
}

