/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIPlugin;
import org.eclipse.platform.discovery.ui.internal.view.impl.ITabbedSessionDisplayer;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TabbedSessionDisplayer<T>
implements ITabbedSessionDisplayer<T> {
    private static final String FW_IMG_E = "/icons/e/forward_nav.gif";
    private static final String FW_IMG_D = "/icons/d/forward_nav.gif";
    private static final String BW_IMG_E = "/icons/e/backward_nav.gif";
    private static final String BW_IMG_D = "/icons/d/backward_nav.gif";
    private static final Image fwImgE = new Image((Device)TabbedSessionDisplayer.getDisplayForCreateImage(), TabbedSessionDisplayer.class.getResourceAsStream("/icons/e/forward_nav.gif"));
    private static final Image fwImgD;
    private static final Image bwImgE;
    private static final Image bwImgD;
    private final Set<String> unclosableSessions;
    private final CTabFolder tabsFolder;
    private Map<String, SessionTab> displayers = new HashMap<String, SessionTab>();
    private final UIFactory<T> uif;

    static {
        DiscoveryUIPlugin.getDefault().getImageRegistry().put(String.valueOf(TabbedSessionDisplayer.class.getCanonicalName()) + FW_IMG_E, fwImgE);
        fwImgD = new Image((Device)TabbedSessionDisplayer.getDisplayForCreateImage(), TabbedSessionDisplayer.class.getResourceAsStream(FW_IMG_D));
        DiscoveryUIPlugin.getDefault().getImageRegistry().put(String.valueOf(TabbedSessionDisplayer.class.getCanonicalName()) + FW_IMG_D, fwImgD);
        bwImgE = new Image((Device)TabbedSessionDisplayer.getDisplayForCreateImage(), TabbedSessionDisplayer.class.getResourceAsStream(BW_IMG_E));
        DiscoveryUIPlugin.getDefault().getImageRegistry().put(String.valueOf(TabbedSessionDisplayer.class.getCanonicalName()) + BW_IMG_E, bwImgE);
        bwImgD = new Image((Device)TabbedSessionDisplayer.getDisplayForCreateImage(), TabbedSessionDisplayer.class.getResourceAsStream(BW_IMG_D));
        DiscoveryUIPlugin.getDefault().getImageRegistry().put(String.valueOf(TabbedSessionDisplayer.class.getCanonicalName()) + BW_IMG_D, bwImgD);
    }

    private static Display getDisplayForCreateImage() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public TabbedSessionDisplayer(Composite parent, UIFactory<T> uif, int tabFolderStyle) {
        this.tabsFolder = this.createSessionsTabFolder(parent, uif, tabFolderStyle | 0x800);
        this.tabsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem selectedTabItem = (CTabItem)e.item;
                SessionTab visibleSessionTab = TabbedSessionDisplayer.this.sessionTabForTabItem(selectedTabItem);
                for (SessionTab st : TabbedSessionDisplayer.this.displayers.values()) {
                    st.handleVisibilityChange(st.equals(visibleSessionTab));
                }
            }
        });
        this.uif = uif;
        this.unclosableSessions = new HashSet<String>();
    }

    public CTabFolder getControl() {
        return this.tabsFolder;
    }

    @Override
    public void dispose() {
        this.tabsFolder.dispose();
    }

    private CTabFolder createSessionsTabFolder(Composite parent, UIFactory<T> uif, int style) {
        CTabFolder t = new CTabFolder(parent, style);
        t.setSimple(false);
        t.setUnselectedCloseVisible(false);
        t.setUnselectedImageVisible(false);
        uif.getFormTookit().adapt((Composite)t);
        return t;
    }

    private SessionTab sessionTab(final ISession<T> session) {
        SessionTab sd = this.displayers.get(session.getId());
        if (sd != null) {
            return sd;
        }
        sd = new SessionTab(session);
        this.displayers.put(session.getId(), sd);
        sd.tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedSessionDisplayer.this.displayers.remove(session.getId());
            }
        });
        return sd;
    }

    @Override
    public void display(ISession<T> session) {
        this.sessionTab(session).display();
    }

    @Override
    public void setSessionUnclosable(String sessionId) {
        this.unclosableSessions().add(sessionId);
    }

    private Set<String> unclosableSessions() {
        return this.unclosableSessions;
    }

    private SessionTab sessionTabForTabItem(CTabItem tabItem) {
        for (SessionTab sessionTab : this.displayers.values()) {
            if (!sessionTab.tabItem().equals(tabItem)) continue;
            return sessionTab;
        }
        throw new IllegalStateException("Unknown tab item");
    }

    private class SessionTab {
        final CTabItem tabItem;
        private final Composite tabComposite;
        private final ISession<T> session;
        private ToolBar toolbar;
        private ToolItem prevButton;
        private ToolItem nextButton;
        private UI currentSessionUI;
        private final Property<Boolean> tabVisibleProperty;

        public SessionTab(ISession<T> session) {
            this.session = session;
            this.tabComposite = TabbedSessionDisplayer.this.uif.getFormTookit().createComposite((Composite)TabbedSessionDisplayer.this.tabsFolder, 0);
            this.tabItem = new CTabItem(TabbedSessionDisplayer.this.tabsFolder, this.isUnclosableSession() ? 0 : 64);
            this.tabItem.setControl((Control)this.tabComposite);
            this.tabComposite.setLayout((Layout)new GridLayout(1, true));
            this.tabVisibleProperty = new Property();
            this.tabVisibleProperty.set((Object)false);
            this.tabVisibleProperty.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<Boolean>(){

                public void attributeChanged(PropertyAttributeChangedEvent<Boolean> event) {
                    if (!SessionTab.this.isNavigatableSession()) {
                        return;
                    }
                    if (((Boolean)event.getNewAttribute()).booleanValue()) {
                        SessionTab.this.createToolbarWithNavigationButtons();
                    } else if (SessionTab.this.isNavigatableSession()) {
                        TabbedSessionDisplayer.this.tabsFolder.setTopRight(null, 131072);
                        SessionTab.this.toolbar.dispose();
                        TabbedSessionDisplayer.this.tabsFolder.layout(true, true);
                    }
                }
            }, false);
        }

        public void display() {
            TabbedSessionDisplayer.this.tabsFolder.setSelection(this.tabItem);
            this.tabVisibleProperty.set((Object)true);
            this.installContrubutedUI(TabbedSessionDisplayer.this.uif);
            this.tabItem.setText(this.currentSessionUI.title());
            TabbedSessionDisplayer.this.tabsFolder.layout(true, true);
        }

        private void updateNavButtons() {
            this.prevButton.setEnabled(this.session.historyTrack().hasPrevious());
            this.nextButton.setEnabled(this.session.historyTrack().hasNext());
        }

        private void installContrubutedUI(UIFactory<T> uif) {
            if (this.currentSessionUI != null) {
                this.currentSessionUI.saveControlsState();
                this.currentSessionUI.dispose();
            }
            Composite contributedUiParentComposite = uif.getFormTookit().createComposite(this.tabComposite);
            contributedUiParentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.currentSessionUI = uif.create(this.session.historyTrack().current(), contributedUiParentComposite);
            this.currentSessionUI.createControls();
        }

        private ToolItem createPrevButton() {
            ToolItem pb = new ToolItem(this.toolbar, 8, 0);
            pb.setToolTipText(DiscoveryUIMessages.AbstractSearchResultTab_GoToPrevious);
            pb.setImage(bwImgE);
            pb.setDisabledImage(bwImgD);
            pb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SessionTab.this.session.historyTrack().previous();
                    SessionTab.this.display();
                    SessionTab.this.currentSessionUI.restoreControlsState();
                    SessionTab.this.updateNavButtons();
                }
            });
            return pb;
        }

        private ToolItem createNextButton() {
            ToolItem nb = new ToolItem(this.toolbar, 8, 1);
            nb.setToolTipText(DiscoveryUIMessages.AbstractSearchResultTab_GoToNext);
            nb.setImage(fwImgE);
            nb.setDisabledImage(fwImgD);
            nb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SessionTab.this.session.historyTrack().next();
                    SessionTab.this.display();
                    SessionTab.this.currentSessionUI.restoreControlsState();
                    SessionTab.this.updateNavButtons();
                }
            });
            return nb;
        }

        private ToolBar createToolBar() {
            ToolBar tb = new ToolBar((Composite)TabbedSessionDisplayer.this.tabsFolder, 8520000);
            TabbedSessionDisplayer.this.uif.getFormTookit().adapt((Composite)tb);
            tb.setLayoutData((Object)new GridData(4, 1, true, false));
            TabbedSessionDisplayer.this.tabsFolder.setTabHeight(Math.max(tb.computeSize((int)-1, (int)-1).y, TabbedSessionDisplayer.this.tabsFolder.getTabHeight()));
            TabbedSessionDisplayer.this.tabsFolder.setTopRight((Control)tb, 131072);
            TabbedSessionDisplayer.this.tabsFolder.redraw();
            return tb;
        }

        private boolean isNavigatableSession() {
            return this.session.historyTrack().historyLimit() > 1;
        }

        private boolean isUnclosableSession() {
            return TabbedSessionDisplayer.this.unclosableSessions().contains(this.session.getId());
        }

        public CTabItem tabItem() {
            return this.tabItem;
        }

        public void handleVisibilityChange(boolean visible) {
            this.tabVisibleProperty.set((Object)visible);
        }

        private void createToolbarWithNavigationButtons() {
            this.toolbar = this.createToolBar();
            this.prevButton = this.createPrevButton();
            this.nextButton = this.createNextButton();
            this.updateNavButtons();
            Point parentSize = this.toolbar.getParent().getSize();
            Point tbSize = this.toolbar.computeSize(-1, -1);
            Rectangle tbBounds = this.toolbar.getBounds();
            this.toolbar.setBounds(parentSize.x - tbSize.x, tbBounds.y, tbSize.x, tbBounds.height);
        }
    }

    public static interface UI {
        public void createControls();

        public void saveControlsState();

        public void restoreControlsState();

        public Composite parent();

        public void dispose();

        public String title();
    }

    public static interface UIFactory<T> {
        public UI create(T var1, Composite var2);

        public FormToolkit getFormTookit();
    }
}

