/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.testutils.utils.pageobjects;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class InShellPageObject {
    private SWTBotShell botShell;
    private static final String TEST_SHELL_LABEL = "Testing Shell";
    private FormToolkit formToolkit;

    public void open() {
        Shell shell = this.createShell();
        this.botShell = new SWTBotShell(shell);
        this.botShell.activate();
    }

    public void close() {
        this.botShell.close();
    }

    protected abstract void createContent(Shell var1, FormToolkit var2);

    protected void dispose(DisposeEvent e) {
        this.formToolkit.dispose();
    }

    protected Display display() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    protected Shell createShell() {
        final Shell[] theShell = new Shell[1];
        Runnable createShellRunnable = new Runnable(){

            @Override
            public void run() {
                InShellPageObject.this.formToolkit = new FormToolkit(InShellPageObject.this.display());
                theShell[0] = new Shell(InShellPageObject.this.display(), 16);
                theShell[0].setText(InShellPageObject.TEST_SHELL_LABEL);
                theShell[0].setLayout((Layout)new FillLayout());
                InShellPageObject.this.createContent(theShell[0], InShellPageObject.this.formToolkit);
                theShell[0].layout(true);
                theShell[0].addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        InShellPageObject.this.dispose(e);
                    }
                });
                theShell[0].open();
            }
        };
        this.display().syncExec(createShellRunnable);
        return theShell[0];
    }

    protected SWTBot bot() {
        return this.botShell.bot();
    }

    protected SWTBotShell shell() {
        return this.botShell;
    }

    public Shell getShell() {
        return (Shell)this.botShell.widget;
    }
}

