/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.selector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.core.internal.selectors.IItemSelector;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.view.IGetControlObject;
import org.eclipse.platform.discovery.ui.internal.view.impl.DestinationsContentProvider;
import org.eclipse.platform.discovery.ui.internal.view.impl.DestinationsLabelProvider;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SearchDestinationsSelector
implements IItemSelector<ISearchDestination, IDestinationCategoryDescription>,
IGetControlObject<Control> {
    private final TreeViewer destinationsTreeViewer;
    private final Property<IStructuredSelection> lastKnownSelection = new Property();

    public SearchDestinationsSelector(Composite parent, FormToolkit formToolkit, int secondColumnPosition, Control topNeighbourControl) {
        this.lastKnownSelection.set((Object)new StructuredSelection());
        this.lastKnownSelection.registerValueListener((IPropertyAttributeListener)new SelectionChangedListener(), false);
        Label destinationLabel = new Label(parent, 0x800000);
        destinationLabel.setText(DiscoveryUIMessages.SEARCH_IN_LIST_VIEWER_LABEL);
        FormData labelSearchedInFormData = new FormData();
        labelSearchedInFormData.left = new FormAttachment(0, 5);
        labelSearchedInFormData.top = new FormAttachment(topNeighbourControl, 5);
        destinationLabel.setLayoutData((Object)labelSearchedInFormData);
        this.destinationsTreeViewer = this.createDestinationsTreeViewer(parent);
        formToolkit.adapt(this.destinationsTreeViewer.getControl(), true, true);
        FormData searchInFormData = new FormData();
        searchInFormData.top = new FormAttachment(topNeighbourControl, 5);
        searchInFormData.left = new FormAttachment(0, secondColumnPosition + 10);
        searchInFormData.right = new FormAttachment(100, -5);
        searchInFormData.height = Math.max(this.destinationsTreeViewer.getControl().computeSize((int)-1, (int)-1).y, this.treeViewerMinHeight());
        this.destinationsTreeViewer.getControl().setLayoutData((Object)searchInFormData);
    }

    public ISearchDestination getSelectedItem() {
        Object selectedObject = ((IStructuredSelection)this.destinationsTreeViewer.getSelection()).getFirstElement();
        if (selectedObject instanceof IDestinationCategoryDescription) {
            return null;
        }
        return (ISearchDestination)selectedObject;
    }

    private TreeViewer createDestinationsTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        viewer.setContentProvider((IContentProvider)new DestinationsContentProvider(){

            @Override
            protected List<ISearchDestination> getSearchDestinationsForCategory(IDestinationCategoryDescription category) {
                ArrayList<ISearchDestination> result = new ArrayList<ISearchDestination>();
                for (IDestinationsProvider destinationsProvider : SearchDestinationsSelector.this.getDestinationProvidersForCategory(category)) {
                    result.addAll(SearchDestinationsSelector.this.getSearchDestinations(category, destinationsProvider));
                }
                return result;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new DestinationsLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    SearchDestinationsSelector.this.handleSelectionChange(null);
                    return;
                }
                SearchDestinationsSelector.this.lastKnownSelection.set((Object)((IStructuredSelection)event.getSelection()));
            }
        });
        return viewer;
    }

    @Override
    public Control getControl() {
        return this.destinationsTreeViewer.getControl();
    }

    public void setInput(List<IDestinationCategoryDescription> input) {
        this.updateInternal(input);
    }

    public void update() {
        this.updateInternal((List)this.destinationsTreeViewer.getInput());
    }

    private void updateInternal(List<IDestinationCategoryDescription> input) {
        this.destinationsTreeViewer.setInput(input);
        this.refreshAndExpandTreeViewer(this.destinationsTreeViewer);
        if (!input.isEmpty()) {
            this.restoreLastKnownSelection(this.destinationsTreeViewer);
        }
        if (input.size() == 1) {
            HashSet<ISearchDestination> result = new HashSet<ISearchDestination>();
            for (IDestinationsProvider destinationsProvider : this.getDestinationProvidersForCategory(input.iterator().next())) {
                result.addAll(this.getSearchDestinations(input.iterator().next(), destinationsProvider));
            }
            if (result.size() == 1) {
                this.destinationsTreeViewer.setSelection((ISelection)new StructuredSelection(result.iterator().next()));
            }
        }
    }

    private void refreshAndExpandTreeViewer(TreeViewer viewer) {
        viewer.refresh();
        viewer.expandAll();
    }

    private void restoreLastKnownSelection(TreeViewer viewer) {
        viewer.setSelection((ISelection)this.lastKnownSelection.get(), true);
        this.lastKnownSelection.set((Object)((IStructuredSelection)viewer.getSelection()));
    }

    public void setEnabled(boolean enabled) {
        this.destinationsTreeViewer.getControl().setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.destinationsTreeViewer.getControl().isEnabled();
    }

    protected abstract Set<IDestinationsProvider> getDestinationProvidersForCategory(IDestinationCategoryDescription var1);

    protected abstract List<ISearchDestination> getSearchDestinations(IDestinationCategoryDescription var1, IDestinationsProvider var2);

    protected int treeViewerMinHeight() {
        return 80;
    }

    private class SelectionChangedListener
    implements IPropertyAttributeListener<IStructuredSelection> {
        private SelectionChangedListener() {
        }

        public void attributeChanged(PropertyAttributeChangedEvent<IStructuredSelection> event) {
            IStructuredSelection selection = (IStructuredSelection)event.getNewAttribute();
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof ISearchDestination)) {
                SearchDestinationsSelector.this.handleSelectionChange(null);
                return;
            }
            SearchDestinationsSelector.this.handleSelectionChange((ISearchDestination)selection.getFirstElement());
        }
    }
}

