/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.api.ISearchConsoleMasterController;
import org.eclipse.platform.discovery.core.api.ISearchConsoleSlaveController;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesSlaveController;
import org.eclipse.platform.discovery.core.api.ISlaveController;
import org.eclipse.platform.discovery.core.internal.IDiscoveryView;
import org.eclipse.platform.discovery.core.internal.ISearchConsoleView;
import org.eclipse.platform.discovery.core.internal.ISearchSession;
import org.eclipse.platform.discovery.core.internal.SearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.core.internal.favorites.ISearchFavoritesControllerOutputView;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesContentManager;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesController;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesPersistenceUtil;
import org.eclipse.platform.discovery.integration.internal.plugin.DiscoveryIntegrationMessages;
import org.eclipse.platform.discovery.integration.internal.plugin.ISlaveControllersConfiguration;
import org.eclipse.platform.discovery.integration.internal.plugin.IViewCustomizationConfiguration;
import org.eclipse.platform.discovery.integration.internal.plugin.SearchSessionFactory;
import org.eclipse.platform.discovery.integration.internal.slavecontrollers.SlaveControllersConfiguration;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.ViewCustomizationConfiguration;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.SearchProviderConfigurationFactory;
import org.eclipse.platform.discovery.runtime.internal.persistence.IMementoContentManager;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.runtime.internal.persistence.util.IPersistenceProviderRegistry;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.api.impl.DefaultSessionIds;
import org.eclipse.platform.discovery.ui.api.impl.ErrorHandler;
import org.eclipse.platform.discovery.ui.internal.view.ICustomizableView;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.platform.discovery.util.internal.longop.ModalContextLongOpRunner;
import org.eclipse.platform.discovery.util.internal.session.ISessionFactory;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;
import org.eclipse.platform.discovery.util.internal.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DiscoveryIntegrationPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.platform.discovery.integration";
    static final String SEARCH_CONSOLE_VIEW_ID = "org.eclipse.platform.discovery.ui.internal.view.SearchConsoleView";
    static final String SEARCH_FAVORITES_VIEW_ID = "org.eclipse.platform.discovery.ui.internal.view.SearchFavoritesView";
    private static final String SEARCH_FAVORITES_STORAGE_FILENAME = "searchFavoritesViewState.memento";
    private volatile ISearchConsoleController consoleController;
    private volatile ISearchFavoritesMasterController searchFavoritesController;
    private volatile ISessionManager<ISearchSession> sessionManager = new SessionManager((ISessionFactory)new SearchSessionFactory());
    private PluginPartListener openViewPartListener;
    private static DiscoveryIntegrationPlugin plugin;
    private ISchedulingRule searchRule = new SearchScheudlingRule();
    private final Set<Thread> threadTracker = new HashSet<Thread>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job(DiscoveryIntegrationMessages.CONSOLE_INIT_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DiscoveryIntegrationPlugin.this.createControllerIfViewOpened();
                        DiscoveryIntegrationPlugin.this.createControllerOnViewOpen();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createControllerIfViewOpened() {
        IViewReference[] viewReferences;
        IViewReference[] iViewReferenceArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference vref = iViewReferenceArray[n2];
            this.partOpenedInternal((IWorkbenchPartReference)vref);
            ++n2;
        }
    }

    private void createControllerOnViewOpen() {
        this.openViewPartListener = new PluginPartListener();
        this.getPartService().addPartListener((IPartListener2)this.openViewPartListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiscoveryIntegrationPlugin.this.disposeController();
            }
        });
    }

    private void disposeController() {
        this.getPartService().removePartListener((IPartListener2)this.openViewPartListener);
    }

    private IPartService getPartService() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
    }

    public static DiscoveryIntegrationPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DiscoveryIntegrationPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected synchronized ISearchConsoleController createSearchConsoleController(ISearchConsoleControllerOutputView controllerView, ISearchProviderConfiguration searchProviderConfig, IDiscoveryEnvironment environment) {
        return new SearchConsoleController(searchProviderConfig, controllerView, environment, this.sessionManager, DefaultSessionIds.mainSearchSessionId);
    }

    protected ILongOperationRunner longOperationRunner(IProgressMonitor monitor) {
        return new ModalContextLongOpRunner(monitor, this.searchRule){

            protected Set<Thread> newThreadTracker() {
                return DiscoveryIntegrationPlugin.this.threadTracker;
            }
        };
    }

    public void earlyStartup() {
    }

    protected void partOpenedInternal(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(SEARCH_CONSOLE_VIEW_ID)) {
            this.handleSearchConsoleViewOpened(partRef);
        } else if (partRef.getId().equals(SEARCH_FAVORITES_VIEW_ID)) {
            this.handleSearchFavoritesViewOpened(partRef);
        }
    }

    private void handleSearchConsoleViewOpened(IWorkbenchPartReference partRef) {
        if (this.consoleController != null) {
            return;
        }
        IWorkbenchPart wbPart = partRef.getPart(false);
        if (wbPart != null) {
            ISearchConsoleView consoleView = this.getBusinessViewFromPart(wbPart);
            ICustomizableView customizableView = this.getCustomizableViewFromPart(wbPart);
            IMasterDiscoveryView masterView = this.getMasterViewFromPart(wbPart);
            ILongOperationRunner runner = this.longOperationRunner(consoleView.getProgressMonitor());
            IDiscoveryEnvironment environment = this.createConsoleEnvironment(this.errorHandler(), runner, consoleView);
            consoleView.setEnvironment(environment);
            consoleView.setDefaultSessionId(DefaultSessionIds.mainSearchSessionId);
            this.consoleController = this.createSearchConsoleController((ISearchConsoleControllerOutputView)consoleView.getControllerView(), this.searchProviderConfiguration(), environment);
            List<ISearchConsoleSlaveController> slaveControllers = this.slaveControllersConfig().availableSearchConsoleSlaveControllers();
            this.configureSlaveControllers((ISearchConsoleMasterController)this.consoleController, slaveControllers);
            HashSet<ISearchConsoleCustomization> viewCust = new HashSet<ISearchConsoleCustomization>(this.viewCustomizationsConfig().availableSearchConsoleCustomizations());
            this.customizeView(customizableView, masterView, new HashSet<ISearchConsoleSlaveController>(slaveControllers), viewCust);
            consoleView.registerController((Object)this.consoleController);
            consoleView.initializationCompleted();
        } else {
            Logger.instance().logWarn("Search console view could not be created");
        }
    }

    private void handleSearchFavoritesViewOpened(IWorkbenchPartReference partRef) {
        if (this.searchFavoritesController != null) {
            return;
        }
        IWorkbenchPart wbPart = partRef.getPart(false);
        if (wbPart != null) {
            final IDiscoveryView<ISearchFavoritesControllerOutputView, ISearchFavoritesMasterController> favoritesView = this.getSearchFavoritesViewFromPart(wbPart);
            final ILongOperationRunner runner = this.longOperationRunner(favoritesView.getProgressMonitor());
            IDiscoveryEnvironment env = new IDiscoveryEnvironment(){

                public IErrorHandler errorHandler() {
                    return DiscoveryIntegrationPlugin.this.errorHandler();
                }

                public ILongOperationRunner operationRunner() {
                    return runner;
                }

                public IProgressMonitor progressMonitor() {
                    return favoritesView.getProgressMonitor();
                }
            };
            favoritesView.setEnvironment(env);
            ICustomizableView customizableView = this.getCustomizableViewFromPart(wbPart);
            IMasterDiscoveryView masterView = this.getMasterViewFromPart(wbPart);
            List<ISearchFavoritesSlaveController> slaveControllers = this.slaveControllersConfig().availableSearchFavoritesSlaveControllers();
            HashSet<ISearchFavoritesViewCustomization> viewCust = new HashSet<ISearchFavoritesViewCustomization>(this.viewCustomizationsConfig().availableSearchFavoritesCustomizations());
            this.searchFavoritesController = this.createSearchFavoritesController((ISearchFavoritesControllerOutputView)favoritesView.getControllerView(), env);
            favoritesView.registerController((Object)this.searchFavoritesController);
            for (ISearchFavoritesSlaveController sc : slaveControllers) {
                sc.setMasterController(this.searchFavoritesController);
            }
            this.customizeView(customizableView, masterView, new HashSet<ISearchFavoritesSlaveController>(slaveControllers), viewCust);
            favoritesView.initializationCompleted();
        } else {
            Logger.instance().logWarn("Search favorites view could not be created");
        }
    }

    private void customizeView(ICustomizableView customizableView, IMasterDiscoveryView masterView, Set<ISlaveController> slaveControllers, Set<IGenericViewCustomization> viewCustomizations) {
        customizableView.setUiContext(this.createViewUiContext());
        this.registerActionsInView(customizableView, slaveControllers);
        this.configureViewCustomizations(masterView, viewCustomizations);
        for (IGenericViewCustomization viewCust : viewCustomizations) {
            customizableView.registerViewCustomization(viewCust);
        }
    }

    protected synchronized ISearchFavoritesMasterController createSearchFavoritesController(ISearchFavoritesControllerOutputView favoritesView, IDiscoveryEnvironment env) {
        return new SearchFavoritesController(favoritesView, env, (IPersistenceUtil)new SearchFavoritesPersistenceUtil(this.createSearchFavoritesPersistenceContext()));
    }

    private SearchFavoritesPersistenceUtil.IPersistenceContext<DestinationItemPair> createSearchFavoritesPersistenceContext() {
        return new SearchFavoritesPersistenceUtil.IPersistenceContext<DestinationItemPair>(){
            private IMementoContentManager<DestinationItemPair> cm = null;

            public IMementoContentManager<DestinationItemPair> getContentManager() throws MementoContentManagerException {
                if (this.cm == null) {
                    this.cm = new SearchFavoritesContentManager(IPersistenceProviderRegistry.INSTANCE);
                }
                return this.cm;
            }

            public File getFile() {
                return new File(DiscoveryIntegrationPlugin.getDefault().getStateLocation().toFile(), DiscoveryIntegrationPlugin.SEARCH_FAVORITES_STORAGE_FILENAME);
            }
        };
    }

    public IPersistenceUtil createFavoritesPersistenceUtil() {
        SearchFavoritesPersistenceUtil util = new SearchFavoritesPersistenceUtil(this.createSearchFavoritesPersistenceContext());
        if (this.searchFavoritesController != null) {
            return new IPersistenceUtil((IPersistenceUtil)util){
                private final /* synthetic */ IPersistenceUtil val$util;
                {
                    this.val$util = iPersistenceUtil;
                }

                public void addItems(Set<DestinationItemPair> itemsToAdd, ILongOperationRunner opRunner) throws WorkbenchException, IOException, MementoContentManagerException {
                    DiscoveryIntegrationPlugin.this.searchFavoritesController.importData((Object)itemsToAdd.toArray(new DestinationItemPair[itemsToAdd.size()]));
                }

                public void deleteItems(Set<Object> itemsToDelete, ILongOperationRunner opRunner) throws WorkbenchException, IOException, MementoContentManagerException {
                    DiscoveryIntegrationPlugin.this.searchFavoritesController.deleteItems(itemsToDelete);
                }

                public Set<DestinationItemPair> loadItems(ILongOperationRunner opRunner) throws WorkbenchException, IOException, MementoContentManagerException {
                    return this.val$util.loadItems(opRunner);
                }
            };
        }
        return util;
    }

    private void configureViewCustomizations(IMasterDiscoveryView masterView, Set<IGenericViewCustomization> viewCustomizations) {
        for (IGenericViewCustomization cust : viewCustomizations) {
            cust.setMasterView(masterView);
        }
    }

    private void configureSlaveControllers(ISearchConsoleMasterController masterController, List<ISearchConsoleSlaveController> slaveControllers) {
        for (ISearchConsoleSlaveController slave : slaveControllers) {
            slave.setMasterController(masterController);
        }
    }

    protected ISearchConsoleView getBusinessViewFromPart(IWorkbenchPart part) {
        return (ISearchConsoleView)part;
    }

    protected IDiscoveryView<ISearchFavoritesControllerOutputView, ISearchFavoritesMasterController> getSearchFavoritesViewFromPart(IWorkbenchPart part) {
        return (IDiscoveryView)part;
    }

    protected ICustomizableView getCustomizableViewFromPart(IWorkbenchPart part) {
        return (ICustomizableView)part;
    }

    protected IMasterDiscoveryView getMasterViewFromPart(IWorkbenchPart wbPart) {
        return (IMasterDiscoveryView)wbPart;
    }

    private void registerActionsInView(ICustomizableView customizableView, Set<ISlaveController> slaveControllers) {
        for (ISlaveController slave : slaveControllers) {
            for (IContributedAction singleAction : slave.createActions()) {
                customizableView.registerAction(singleAction);
            }
        }
    }

    private ISearchProviderConfiguration searchProviderConfiguration() {
        return SearchProviderConfigurationFactory.getDefault();
    }

    private IErrorHandler errorHandler() {
        return new ErrorHandler();
    }

    protected ISlaveControllersConfiguration slaveControllersConfig() {
        return new SlaveControllersConfiguration();
    }

    protected IViewCustomizationConfiguration viewCustomizationsConfig() {
        return new ViewCustomizationConfiguration();
    }

    private IDiscoveryEnvironment createConsoleEnvironment(final IErrorHandler errorHandler, final ILongOperationRunner opRunner, final ISearchConsoleView explView) {
        return new IDiscoveryEnvironment(){

            public IErrorHandler errorHandler() {
                return errorHandler;
            }

            public ILongOperationRunner operationRunner() {
                return opRunner;
            }

            public IProgressMonitor progressMonitor() {
                return explView.getProgressMonitor();
            }
        };
    }

    private IViewUiContext createViewUiContext() {
        return new IViewUiContext(){
            private int secondCPosition;

            public int controlsSpacing() {
                return 5;
            }

            public int getSecondColumnPosition() {
                return this.secondCPosition;
            }

            public void setSecondColumnPosition(int position) {
                this.secondCPosition = position;
            }
        };
    }

    private class PluginPartListener
    implements IPartListener2 {
        private PluginPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals(DiscoveryIntegrationPlugin.SEARCH_CONSOLE_VIEW_ID)) {
                DiscoveryIntegrationPlugin.this.consoleController = null;
            } else if (partRef.getId().equals(DiscoveryIntegrationPlugin.SEARCH_FAVORITES_VIEW_ID)) {
                DiscoveryIntegrationPlugin.this.searchFavoritesController = null;
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            DiscoveryIntegrationPlugin.this.partOpenedInternal(partRef);
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }

    private class SearchScheudlingRule
    implements ISchedulingRule {
        private SearchScheudlingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

