/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.properties;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedProperties {
    private static List<String> types;
    private static ResourceBundle TYPED_PROPERTIES;

    static {
        TYPED_PROPERTIES = ResourceBundle.getBundle("org.eclipse.e4.xwt.tools.ui.designer.properties.types");
    }

    public static synchronized List<String> getTypes() {
        if (types == null) {
            types = new ArrayList<String>();
            Enumeration<String> enumeration = TYPED_PROPERTIES.getKeys();
            while (enumeration.hasMoreElements()) {
                types.add(enumeration.nextElement());
            }
            Collections.sort(types);
        }
        return types;
    }

    public static String[] getProperties(String type) {
        ArrayList<String> result = new ArrayList<String>();
        String value = TYPED_PROPERTIES.getString(type);
        StringTokenizer stk = new StringTokenizer(value, ",");
        while (stk.hasMoreElements()) {
            result.add(stk.nextToken().trim());
        }
        return result.toArray(new String[0]);
    }

    public static int getValue(String property) {
        try {
            Field field = SWT.class.getDeclaredField(property);
            return field.getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static ILabelProvider getLabelProvider(final String type) {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Integer) {
                    String[] properties;
                    int intValue = (Integer)element;
                    String[] stringArray = properties = TypedProperties.getProperties(type);
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String prop = stringArray[n2];
                        if (intValue == TypedProperties.getValue(prop)) {
                            return prop;
                        }
                        ++n2;
                    }
                }
                return super.getText(element);
            }
        };
    }
}

