/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout.grid;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.grid.GridLayoutPolicyHelper;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.grid.GridLayoutRequest;
import org.eclipse.swt.layout.GridLayout;

public class GridLayoutGridFigure
extends Figure {
    public static final int ROW_COLUMN_SENSITIVITY = 5;
    private GridLayoutPolicyHelper helper;
    private int marginWidth;
    private int marginHeight;
    private int verticalSpacing;
    private int horizontalSpacing;
    int[] columnModelPositions;
    int[] rowModelPositions;
    Point[] rowStartModelPositions;
    Point[] rowEndModelPositions;
    Point[] columnStartModelPositions;
    Point[] columnEndModelPositions;
    int[][] columnModelSegments;
    int[][] rowModelSegments;

    public GridLayoutGridFigure(GridLayoutPolicyHelper helper) {
        this.helper = helper;
        this.setBounds(helper.getClientArea());
        if (helper != null) {
            Rectangle spacing = helper.getLayoutSpacing();
            this.marginWidth = spacing.x;
            this.marginHeight = spacing.y;
            this.verticalSpacing = spacing.height;
            this.horizontalSpacing = spacing.width;
        } else {
            GridLayout example = new GridLayout();
            this.marginWidth = example.marginWidth;
            this.marginHeight = example.marginHeight;
            this.horizontalSpacing = example.horizontalSpacing;
            this.verticalSpacing = example.verticalSpacing;
        }
        if (helper != null) {
            int[][] layoutDimensions = helper.getLayoutDimensions();
            GridLayoutPolicyHelper.GridComponent[][] cellContents = helper.getLayoutTable();
            if (layoutDimensions != null) {
                int[] columnWidths = layoutDimensions[0];
                int[] rowHeights = layoutDimensions[1];
                this.columnModelSegments = this.calculateColumnDividers(columnWidths, rowHeights, cellContents);
                this.rowModelSegments = this.calculateRowDividers(columnWidths, rowHeights, cellContents);
            }
        }
    }

    protected int[][] calculateColumnDividers(int[] columnWidths, int[] rowHeights, GridLayoutPolicyHelper.GridComponent[][] cellContents) {
        if (rowHeights == null || columnWidths == null) {
            return null;
        }
        int spacingLeft = (int)Math.ceil((double)this.horizontalSpacing / 2.0);
        int spacingRight = (int)Math.floor((double)this.horizontalSpacing / 2.0);
        int spacingTop = (int)Math.ceil((double)this.verticalSpacing / 2.0);
        int spacingBottom = (int)Math.floor((double)this.verticalSpacing / 2.0);
        int containerHeight = 0;
        this.columnModelPositions = new int[columnWidths.length + 1];
        this.columnStartModelPositions = new Point[this.columnModelPositions.length];
        this.columnEndModelPositions = new Point[this.columnModelPositions.length];
        int[][] columnSegments = new int[this.columnModelPositions.length][];
        int i = 0;
        while (i < rowHeights.length) {
            containerHeight += rowHeights[i];
            ++i;
        }
        containerHeight += this.marginHeight * 2;
        Rectangle clientArea = this.getBounds().getCopy();
        int xPos = clientArea.x;
        int yMin = clientArea.y;
        int yMax = clientArea.y + (containerHeight += this.verticalSpacing * (rowHeights.length - 1));
        int xMax = xPos + clientArea.width - 1;
        this.columnModelPositions[0] = xPos;
        this.columnStartModelPositions[0] = new Point(xPos, yMin);
        this.columnEndModelPositions[0] = new Point(xPos, yMax);
        columnSegments[0] = new int[]{yMin, yMax};
        xPos += this.marginWidth;
        int[] colSegs = new int[2 + rowHeights.length * 2];
        int i2 = 1;
        while (i2 < this.columnModelPositions.length) {
            xPos += columnWidths[i2 - 1];
            xPos = i2 < columnWidths.length ? (xPos += spacingLeft) : (xPos += this.marginWidth);
            xPos = Math.min(xPos, xMax);
            Point startPoint = new Point(xPos, yMin);
            this.columnModelPositions[i2] = xPos;
            this.columnStartModelPositions[i2] = startPoint;
            this.columnEndModelPositions[i2] = new Point(xPos, yMax);
            if (i2 < columnWidths.length && i2 < cellContents.length) {
                GridLayoutPolicyHelper.GridComponent[] leftColumn = cellContents[i2 - 1];
                GridLayoutPolicyHelper.GridComponent[] rightColumn = cellContents[i2];
                int yPos = yMin;
                int lastRow = leftColumn.length - 1;
                int colSegsNdx = 0;
                colSegs[colSegsNdx] = yMin;
                boolean prevSpan = true;
                int j = 0;
                while (j < leftColumn.length) {
                    GridLayoutPolicyHelper.GridComponent rightObject;
                    int trueRowHeight = 0;
                    if (j < rowHeights.length) {
                        trueRowHeight = rowHeights[j];
                    }
                    trueRowHeight = j == 0 ? (trueRowHeight += this.marginHeight) : (trueRowHeight += spacingTop);
                    trueRowHeight = j != lastRow ? (trueRowHeight += spacingBottom) : (trueRowHeight += this.marginHeight);
                    GridLayoutPolicyHelper.GridComponent leftObject = leftColumn[j];
                    if (leftObject != this.helper.EMPTY_GRID && (rightObject = rightColumn[j]) != this.helper.EMPTY_GRID && leftObject == rightObject) {
                        if (!prevSpan) {
                            colSegs[++colSegsNdx] = yPos;
                            ++colSegsNdx;
                        }
                        colSegs[colSegsNdx] = (yPos += trueRowHeight) + 1;
                        prevSpan = true;
                    } else {
                        prevSpan = false;
                        yPos += trueRowHeight;
                    }
                    ++j;
                }
                if (colSegs[colSegsNdx] < yPos) {
                    colSegs[++colSegsNdx] = yMax;
                } else {
                    --colSegsNdx;
                }
                columnSegments[i2] = new int[++colSegsNdx];
                System.arraycopy(colSegs, 0, columnSegments[i2], 0, colSegsNdx);
            } else {
                columnSegments[i2] = new int[]{yMin, yMax};
            }
            xPos += spacingRight;
            ++i2;
        }
        return columnSegments;
    }

    protected int[][] calculateRowDividers(int[] columnWidths, int[] rowHeights, GridLayoutPolicyHelper.GridComponent[][] cellContents) {
        if (columnWidths == null || rowHeights == null) {
            return null;
        }
        int spacingLeft = (int)Math.ceil((double)this.horizontalSpacing / 2.0);
        int spacingRight = (int)Math.floor((double)this.horizontalSpacing / 2.0);
        int spacingTop = (int)Math.ceil((double)this.verticalSpacing / 2.0);
        int spacingBottom = (int)Math.floor((double)this.verticalSpacing / 2.0);
        int containerWidth = 0;
        this.rowModelPositions = new int[rowHeights.length + 1];
        this.rowStartModelPositions = new Point[this.rowModelPositions.length];
        this.rowEndModelPositions = new Point[this.rowModelPositions.length];
        int[][] rowSegments = new int[this.rowModelPositions.length][];
        int i = 0;
        while (i < columnWidths.length) {
            containerWidth += columnWidths[i];
            ++i;
        }
        containerWidth += this.marginWidth * 2;
        Rectangle clientArea = this.getBounds().getCopy();
        int yPos = clientArea.y;
        int xMin = clientArea.x;
        int xMax = clientArea.x + (containerWidth += this.horizontalSpacing * (columnWidths.length - 1));
        int yMax = yPos + clientArea.height - 1;
        this.rowModelPositions[0] = yPos;
        this.rowStartModelPositions[0] = new Point(xMin, yPos);
        this.rowEndModelPositions[0] = new Point(xMax, yPos);
        rowSegments[0] = new int[]{xMin, xMax};
        yPos += this.marginHeight;
        int[] rowSegs = new int[2 + columnWidths.length * 2];
        int i2 = 1;
        while (i2 < this.rowModelPositions.length) {
            yPos += rowHeights[i2 - 1];
            yPos = i2 < rowHeights.length ? (yPos += spacingTop) : (yPos += this.marginHeight);
            yPos = Math.min(yPos, yMax);
            Point startPoint = new Point(xMin, yPos);
            Point endPoint = new Point(xMax, yPos);
            this.rowModelPositions[i2] = yPos;
            this.rowStartModelPositions[i2] = startPoint;
            this.rowEndModelPositions[i2] = endPoint;
            if (i2 < rowHeights.length) {
                int upperRow = i2 - 1;
                int lowerRow = i2;
                int xPos = xMin;
                int length = Math.min(cellContents.length, columnWidths.length);
                int lastCol = length - 1;
                int rowSegsNdx = 0;
                rowSegs[rowSegsNdx] = xMin;
                boolean prevSpan = true;
                int j = 0;
                while (j < length) {
                    GridLayoutPolicyHelper.GridComponent lowerObject;
                    int trueColWidth = columnWidths[j];
                    trueColWidth = j == 0 ? (trueColWidth += this.marginWidth) : (trueColWidth += spacingLeft);
                    trueColWidth = j != lastCol ? (trueColWidth += spacingRight) : (trueColWidth += this.marginWidth);
                    GridLayoutPolicyHelper.GridComponent upperObject = cellContents[j][upperRow];
                    if (upperObject != this.helper.EMPTY_GRID && (lowerObject = cellContents[j][lowerRow]) != this.helper.EMPTY_GRID && upperObject == lowerObject) {
                        if (!prevSpan) {
                            rowSegs[++rowSegsNdx] = xPos;
                            ++rowSegsNdx;
                        }
                        rowSegs[rowSegsNdx] = (xPos += trueColWidth) + 1;
                        prevSpan = true;
                    } else {
                        xPos += trueColWidth;
                        prevSpan = false;
                    }
                    ++j;
                }
                if (rowSegs[rowSegsNdx] < xPos) {
                    rowSegs[++rowSegsNdx] = xMax;
                } else {
                    --rowSegsNdx;
                }
                rowSegments[i2] = new int[++rowSegsNdx];
                System.arraycopy(rowSegs, 0, rowSegments[i2], 0, rowSegsNdx);
            } else {
                rowSegments[i2] = new int[]{xMin, xMax};
            }
            yPos += spacingBottom;
            ++i2;
        }
        return rowSegments;
    }

    protected void paintFigure(Graphics g) {
        g.setForegroundColor(ColorConstants.gray);
        g.setLineStyle(3);
        this.drawRowDividers(g);
        this.drawColumnDividers(g);
    }

    protected void drawColumnDividers(Graphics g) {
        if (this.columnModelSegments == null || this.columnStartModelPositions == null) {
            return;
        }
        Point fromPoint = new Point();
        Point toPoint = new Point();
        int i = 0;
        while (i < this.columnModelSegments.length) {
            int[] colSegs = this.columnModelSegments[i];
            int xPos = this.columnStartModelPositions[i].x;
            int j = -1;
            while (++j < colSegs.length) {
                fromPoint.setLocation(xPos, colSegs[j]);
                toPoint.setLocation(xPos, colSegs[++j]);
                g.drawLine(fromPoint, toPoint);
            }
            ++i;
        }
    }

    protected void drawRowDividers(Graphics g) {
        if (this.rowModelSegments == null || this.rowStartModelPositions == null) {
            return;
        }
        Point fromPoint = new Point();
        Point toPoint = new Point();
        int i = 0;
        while (i < this.rowModelSegments.length) {
            int[] rowSegs = this.rowModelSegments[i];
            int yPos = this.rowStartModelPositions[i].y;
            int j = -1;
            while (++j < rowSegs.length) {
                fromPoint.setLocation(rowSegs[j], yPos);
                toPoint.setLocation(rowSegs[++j], yPos);
                g.drawLine(fromPoint, toPoint);
            }
            ++i;
        }
    }

    public Point getCellLocation(Point p) {
        return this.getCellLocation(p.x, p.y);
    }

    public Rectangle getCellBounds(Point pos) {
        if (this.rowModelPositions == null || this.columnModelPositions == null) {
            return new Rectangle(0, 0, 40, 35);
        }
        int cellxpos = pos.x < 0 ? this.columnModelPositions[0] - 40 : this.columnModelPositions[pos.x];
        int cellwidth = pos.x < this.columnModelPositions.length - 1 ? this.columnModelPositions[pos.x + 1] - cellxpos : 40;
        int cellypos = pos.y < 0 ? this.rowModelPositions[0] - 35 : this.rowModelPositions[pos.y];
        int cellheight = pos.y < this.rowModelPositions.length - 1 ? this.rowModelPositions[pos.y + 1] - cellypos : 35;
        return new Rectangle(cellxpos, cellypos, cellwidth, cellheight);
    }

    public Rectangle getColumnRectangle(int col) {
        if (this.columnStartModelPositions != null) {
            return new Rectangle(this.columnStartModelPositions[col], this.columnEndModelPositions[col]).resize(-1, -1);
        }
        return new Rectangle();
    }

    public Rectangle getRowRectangle(int row) {
        if (this.rowStartModelPositions != null) {
            return new Rectangle(this.rowStartModelPositions[row], this.rowEndModelPositions[row]).resize(-1, -1);
        }
        return new Rectangle();
    }

    public Point getCellLocation(int x, int y) {
        return this.getCellLocation(x, y, false, false);
    }

    public Point getCellLocation(int x, int y, boolean includeEmptyColumns, boolean includeEmptyRows) {
        int j;
        if (this.rowModelPositions == null || this.columnModelPositions == null) {
            return new Point(0, 0);
        }
        int gridx = -1;
        int gridy = -1;
        boolean foundx = false;
        boolean foundy = false;
        int i = 0;
        while (i < this.columnModelPositions.length - 1) {
            int xpos = this.columnModelPositions[i];
            if (x >= xpos && x < this.columnModelPositions[i + 1]) {
                gridx = i;
                if (includeEmptyColumns) {
                    j = i;
                    while (j >= 0 && this.columnModelPositions[i] == this.columnModelPositions[j]) {
                        gridx = j + 1;
                        --j;
                    }
                }
                foundx = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowModelPositions.length - 1) {
            int ypos = this.rowModelPositions[i];
            if (y >= ypos && y < this.rowModelPositions[i + 1]) {
                gridy = i;
                if (includeEmptyRows) {
                    j = i;
                    while (j >= 0 && this.rowModelPositions[i] == this.rowModelPositions[j]) {
                        gridy = j + 1;
                        --j;
                    }
                }
                foundy = true;
                break;
            }
            ++i;
        }
        if (!foundx && x >= this.columnModelPositions[this.columnModelPositions.length - 1]) {
            gridx = this.columnModelPositions.length - 1;
        }
        if (!foundy && y >= this.rowModelPositions[this.rowModelPositions.length - 1]) {
            gridy = this.rowModelPositions.length - 1;
        }
        return new Point(gridx, gridy);
    }

    public Rectangle getGridBroundsForCellBounds(Rectangle cellsBounds) {
        Rectangle r = new Rectangle();
        if (this.rowModelPositions != null && this.columnModelPositions != null && cellsBounds.y <= this.rowModelPositions.length - 1 && cellsBounds.x <= this.columnModelPositions.length - 1) {
            r.x = this.columnModelPositions[cellsBounds.x];
            r.y = this.rowModelPositions[cellsBounds.y];
            r.width = cellsBounds.x + cellsBounds.width > this.columnModelPositions.length - 1 ? this.columnModelPositions[this.columnModelPositions.length - 1] : this.columnModelPositions[cellsBounds.x + cellsBounds.width];
            r.width -= r.x;
            r.height = cellsBounds.y + cellsBounds.height > this.rowModelPositions.length - 1 ? this.rowModelPositions[this.rowModelPositions.length - 1] : this.rowModelPositions[cellsBounds.y + cellsBounds.height];
            r.height -= r.y;
        }
        return r;
    }

    public GridLayoutRequest getGridLayoutRequest(Point pos, GridLayoutPolicyHelper helper) {
        Point cell = this.getCellLocation(pos);
        GridLayoutRequest req = new GridLayoutRequest();
        req.column = cell.x;
        req.row = cell.y;
        if (req.column == -1 || req.row == -1) {
            req.type = -1;
        } else if (this.columnModelPositions == null || req.column >= this.columnModelPositions.length - 1) {
            req.type = this.rowModelPositions == null || req.row >= this.rowModelPositions.length - 1 ? 5 : 3;
        } else if (req.row >= this.rowEndModelPositions.length - 1) {
            req.type = 4;
        } else {
            int nextCol = req.column + 1;
            int colWidth = this.columnModelPositions[nextCol] - this.columnModelPositions[req.column];
            int colSensitive = colWidth <= 10 ? (colWidth <= 5 ? 0 : 1) : 5;
            if (pos.x - this.columnModelPositions[req.column] <= colSensitive) {
                if (helper.isEmptyAtCell(cell) || helper.isFillerLabelAtCell(cell)) {
                    req.type = 0;
                } else {
                    Rectangle childDim = helper.getChildDimensions(cell);
                    if (childDim != null && childDim.x < cell.x) {
                        req.type = 1;
                        req.column = childDim.x;
                    } else {
                        req.type = 0;
                    }
                }
            } else if (this.columnModelPositions[nextCol] - pos.x <= colSensitive) {
                cell.x = req.column = nextCol;
                if (req.column < this.columnModelPositions.length - 1) {
                    if (helper.isEmptyAtCell(cell) || helper.isFillerLabelAtCell(cell)) {
                        req.type = 0;
                    } else {
                        Rectangle childDim = helper.getChildDimensions(cell);
                        if (childDim != null && childDim.x < cell.x) {
                            req.type = 1;
                            req.column = childDim.x;
                        } else {
                            req.type = 0;
                        }
                    }
                } else {
                    req.type = 3;
                }
            } else {
                int nextRow = req.row + 1;
                int rowHeight = this.rowModelPositions[nextRow] - this.rowModelPositions[req.row];
                int rowSensitive = rowHeight <= 10 ? (rowHeight <= 5 ? 0 : 2) : 5;
                if (pos.y - this.rowModelPositions[req.row] <= rowSensitive) {
                    if (helper.isEmptyAtCell(cell) || helper.isFillerLabelAtCell(cell)) {
                        req.type = 2;
                    } else {
                        Rectangle childDim = helper.getChildDimensions(cell);
                        if (childDim != null && childDim.y < cell.y) {
                            req.type = 1;
                            req.column = childDim.x;
                        } else {
                            req.type = 2;
                        }
                    }
                } else if (this.rowModelPositions[nextRow] - pos.y <= rowSensitive) {
                    cell.y = req.row = nextRow;
                    int n = req.type = req.row < this.rowModelPositions.length - 1 ? 2 : 4;
                    if (req.row < this.rowModelPositions.length - 1) {
                        Rectangle childDim = helper.getChildDimensions(cell);
                        if (childDim != null && childDim.y < cell.y) {
                            req.type = 1;
                            req.column = childDim.x;
                        } else {
                            req.type = 2;
                        }
                    } else {
                        req.type = 4;
                    }
                } else if (helper.isEmptyAtCell(cell)) {
                    req.type = 7;
                } else if (helper.isFillerLabelAtCell(cell)) {
                    req.type = 6;
                } else {
                    Rectangle childDim = helper.getChildDimensions(cell);
                    req.type = 1;
                    if (childDim != null && childDim.x < cell.x) {
                        req.column = childDim.x;
                    }
                }
            }
        }
        return req;
    }
}

