/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.ui.workbench.renderers.swt.TrimBarLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TrimmedPartLayout
extends Layout {
    public int gutterBottom = 0;
    public int gutterLeft = 0;
    public int gutterTop = 0;
    public int gutterRight = 0;
    public Composite top;
    public Composite bottom;
    public Composite left;
    public Composite right;
    public Composite clientArea;

    public TrimmedPartLayout(Composite parent) {
        this.clientArea = new Composite(parent, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(-1, -1);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle newBounds;
        Rectangle ca = composite.getClientArea();
        Rectangle caRect = new Rectangle(ca.x, ca.y, ca.width, ca.height);
        if (this.top != null) {
            Point topSize = this.top.computeSize(caRect.width, -1, true);
            caRect.y += topSize.y;
            caRect.height -= topSize.y;
            newBounds = new Rectangle(ca.x, ca.y, caRect.width, topSize.y);
            if (!newBounds.equals((Object)this.top.getBounds())) {
                this.top.setBounds(newBounds);
            }
        }
        caRect.y += this.gutterTop;
        caRect.height -= this.gutterTop;
        if (this.bottom != null) {
            Point bottomSize = this.bottom.computeSize(caRect.width, -1, true);
            caRect.height -= bottomSize.y;
            newBounds = new Rectangle(caRect.x, caRect.y + caRect.height, caRect.width, bottomSize.y);
            if (!newBounds.equals((Object)this.bottom.getBounds())) {
                this.bottom.setBounds(newBounds);
            }
        }
        caRect.height -= this.gutterBottom;
        if (this.left != null) {
            Point leftSize = this.left.computeSize(-1, caRect.height, true);
            caRect.x += leftSize.x;
            caRect.width -= leftSize.x;
            newBounds = new Rectangle(caRect.x - leftSize.x, caRect.y, leftSize.x, caRect.height);
            if (!newBounds.equals((Object)this.left.getBounds())) {
                this.left.setBounds(newBounds);
            }
        }
        caRect.x += this.gutterLeft;
        caRect.width -= this.gutterLeft;
        if (this.right != null) {
            Point rightSize = this.right.computeSize(-1, caRect.height, true);
            caRect.width -= rightSize.x;
            newBounds = new Rectangle(caRect.x + caRect.width, caRect.y, rightSize.x, caRect.height);
            if (!newBounds.equals((Object)this.right.getBounds())) {
                this.right.setBounds(newBounds);
            }
        }
        caRect.width -= this.gutterRight;
        if (!caRect.equals((Object)this.clientArea.getBounds())) {
            this.clientArea.setBounds(caRect);
        }
    }

    public Composite getTrimComposite(Composite parent, int side) {
        if (side == 128) {
            if (this.top == null) {
                this.top = new Composite(parent, 0);
                this.top.setLayout((Layout)new TrimBarLayout(true));
                this.top.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        TrimmedPartLayout.this.top = null;
                    }
                });
            }
            return this.top;
        }
        if (side == 1024) {
            if (this.bottom == null) {
                this.bottom = new Composite(parent, 0);
                this.bottom.setLayout((Layout)new TrimBarLayout(true));
                this.bottom.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        TrimmedPartLayout.this.bottom = null;
                    }
                });
            }
            return this.bottom;
        }
        if (side == 16384) {
            if (this.left == null) {
                this.left = new Composite(parent, 0);
                this.left.setLayout((Layout)new TrimBarLayout(false));
                this.left.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        TrimmedPartLayout.this.left = null;
                    }
                });
            }
            return this.left;
        }
        if (side == 131072) {
            if (this.right == null) {
                this.right = new Composite(parent, 0);
                this.right.setLayout((Layout)new TrimBarLayout(false));
                this.right.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        TrimmedPartLayout.this.right = null;
                    }
                });
            }
            return this.right;
        }
        return null;
    }

    public Rectangle getTrimRect(int side) {
        Rectangle caBounds = this.clientArea.getBounds();
        caBounds = this.top.getDisplay().map((Control)this.clientArea.getParent(), null, caBounds);
        if (side == 128) {
            if (this.top != null) {
                Rectangle b = this.top.getBounds();
                b = this.top.getDisplay().map((Control)this.top.getParent(), null, b);
                return b;
            }
            caBounds.height = 25;
            return caBounds;
        }
        if (side == 1024) {
            if (this.bottom != null) {
                Rectangle b = this.bottom.getBounds();
                b = this.bottom.getDisplay().map((Control)this.bottom.getParent(), null, b);
                return b;
            }
            caBounds.y = caBounds.y + caBounds.height - 25;
            caBounds.height = 25;
            return caBounds;
        }
        if (side == 16384) {
            if (this.left != null && this.left.getChildren().length > 0) {
                Rectangle b = this.left.getBounds();
                b = this.left.getDisplay().map((Control)this.left.getParent(), null, b);
                return b;
            }
            caBounds.width = 25;
            return caBounds;
        }
        if (side == 131072) {
            if (this.right != null && this.right.getChildren().length > 0) {
                Rectangle b = this.right.getBounds();
                b = this.right.getDisplay().map((Control)this.right.getParent(), null, b);
                return b;
            }
            caBounds.x = caBounds.x + caBounds.width - 25;
            caBounds.width = 25;
            return caBounds;
        }
        return null;
    }
}

